%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% contains the main predicate
%
% Andre Neumann
%
% last modification: July 2003
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Output predicates:  main.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

outputfile('output').
inputfile('input').

confirm(11).
true_return(17).
false_return(18).
exoaction(16).

delaytime(500).
waittime(100).

:- ensure_loaded('ecl/lego_ecl.pl').
:- ensure_loaded('ecl/legorcx.pl').

doAction(Send)      :- sendAction(Send).
doExoAction(Result) :- sendExoAction(Result).

main :- initRcx,
	loop.

loop :- readOutput(Message),
	write('Read '),write(Message), writeln(' from output file and execute action'),
	doAction(Message),

	writeln('Get confirm'),
	confirm(Confirm),
	writeInput(Confirm),

	true_return(True),
	doExoAction(True),
	writeln('Receive true'),
	writeInput(True),nl,nl,
	loop.

%
%1. lese output
%2. sende nachricht bis confirm
%3. input->confirm zurck
%4. sende exoaction bis true oder false
%5. input->true oder false 
%6. gehe zu 1
%

writeInput(Value) :-
	inputfile(File),
	not exists(File),
	open(File, write, Str),
%	write(' ... write '), writeln(Value),
	write(Str, Value),
	nl(Str),
	close(Str), !.
writeInput(Value) :-
	!, writeInput(Value).

readOutput(Value) :- 
	outputfile(File),
	exists(File),
	open(File, read, Str),
	read(Str, Value),
%	write(' ... read '), writeln(Value),
	close(Str), 
	delete(File), !.
readOutput(Value) :-
	!, sleep(0.1), readOutput(Value).


%
%
%
sendAction(Action) :-
    currentTime(Now),
    delaytime(Delay),
    End is Now + Delay,
    confirm(Confirm),
    sendRcxMessage(Action, End, Confirm), !.
sendAction(_) :-
    writeln('ERROR (sendAction): acknowlegde timeout'), !.

%
%
%
sendExoAction(Result) :-
    currentTime(Now),
    delaytime(Delay),
    End is Now + Delay,
    exoaction(ExoAction),
    sendRcxMessage(ExoAction, End, Result).
sendExoAction(Result) :-
    waittime(Time),
    wait_secs(Time),
    sendExoAction(Result).

%
%
%
wait_secs(Secs) :-
    currentTime(Now),
    End is Now + Secs,
    wait_secs(Now, End).
wait_secs(Now, End) :-
    End < Now, !.
wait_secs(_, End) :-
    currentTime(Now),
    wait_secs(Now, End).
