/*File Name: run.cpp
  Author: Betti Oesterholz ; Date: 12.01.2005
  System: C++

  Copyright (C) 2004  Betti Oesterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

compile file with:
	g++ -Wall -g -o run run.cpp
	g++ -Wall -g -O -o run run.cpp
	g++ -Wall -g -O1 -o run run.cpp

This file contains the main method to run the univers.
*/

#include <iostream>
#include <stdio.h>
#include <fstream>

#include "cUniversTools.h"
#include "nReadValues.h"

using namespace std;
using namespace nReadValues;

const long maxDiff=1000000;

/*the absL function for long values*/
long absL( long lNumber ){

	if ( lNumber<0 ){
		return lNumber*(-1L);
	}//else
	return lNumber;
}


class TripelcPoint{
public:
	cPoint *inPoint;//point from wich the distance goes
	int nboPInDistances;
	int nboNInDistances;
	cPoint *outPoint;//point to wich the distance goes
	int nboPOutDistances;
	int nboNOutDistances;
	TripelcPoint *altPoint;//alternitiv point
	long differenceOutAlt;

	TripelcPoint(){}

	/*evalues the differenc betwean this out point and the given tripel point in point*/
	long getDiffernce(TripelcPoint &tPoi){
		return absL(nboPOutDistances-tPoi.nboPInDistances)+absL(nboNOutDistances-tPoi.nboPInDistances);
	}
};

void printGPL(){
	cout<<"Copyright (C) 2004  Betti Oesterholz"<<endl<<endl;
	cout<<"This program is free software; you can redistribute it and/or modify"<<endl;
	cout<<"it under the terms of the GNU General Public License as published by"<<endl;
	cout<<"the Free Software Foundation; either version 2, June 1991, of the License, or"<<endl;
	cout<<"(at your option) any later version."<<endl<<endl;
	cout<<"This program is distributed in the hope that it will be useful,"<<endl;
	cout<<"but WITHOUT ANY WARRANTY; without even the implied warranty of"<<endl;
	cout<<"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the"<<endl;
	cout<<"GNU General Public License for more details."<<endl<<endl;
	cout<<"You should have received a copy of the GNU General Public License"<<endl;
	cout<<"along with this program; if not, write to the Free Software"<<endl;
	cout<<"Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA"<<endl<<endl;
}

int main(int argc,char* argv[]){
	printGPL();
	
	cUniversTools univ;
	cout<<endl<<endl<<"Bitte geben sie den Pfad der Raumuniversumsdatei an, aus der ein Punkt ausgeschnitten werden soll. "<<endl;
	cout<<"Pfad: ";
	char* uPfad=new char[1000];
	cin>>uPfad;
	//uPfad="univ30.txt";
	
	ifstream uFile(uPfad);
	if(uFile)
	{
		if(univ.readUnivers(uFile))
		{
		uFile.close();
		while(true){
	//		cUniversTools univ(univS);
			//copy constructor cPoint don't work
			cout<<endl<<endl<<"Bitte geben sie den Namen (bzw. Nummer) des Mittelpunkt der auszuschneidenden Menge an."<<endl;
			cout<<"Name: ";
			unsigned long Point;
			cin>>Point;
			//find point in the univers
			list<unsigned long> tmpL;
			tmpL.push_back(Point);
			list<cPoint*> area=univ.findPoints(tmpL);
			if(area.empty()){
				cout<<endl<<endl<<"Keine Punkt mit diesem Namen im Universum vorhanden!"<<endl;
			}else{
				cout<<endl<<endl<<"Bis zu welchem Abstand um den Punkt sollen seine Nachbarn in das neue Raumuniversum?"<<endl;
				cout<<"Abstand: ";
				unsigned int dist=1;
				cin>>dist;
	
				cout<<endl<<endl<<"Bitte geben sie den Pfad der Raumuniversumsdatei an, in der das neue Raumuniversum ";
				cout<<"abgespeichert werden soll. "<<endl<<"Pfad: ";
				cin>>uPfad;
	//			uPfad="tmp.txt";
	
				cout<<endl<<endl<<"Weitere Optionen:"<<endl;
				cout<<"0. keine Aenderung und kein loeschen der Distanzenarten vornehmen"<<endl;
				cout<<"1. Negative Distanzen aus dem Bereich loeschen"<<endl;
				cout<<"2. Positive Distanzen aus dem Bereich loeschen"<<endl;
				cout<<"3. Negative Distanzen aus dem Bereich zu positive Distanzen aendern"<<endl;
				cout<<"4. Positive Distanzen aus dem Bereich zu negative Distanzen aendern"<<endl;
				cout<<"5. Keinen Raumuniversum erzeugen, sondern nur Daten anzeigen"<<endl<<"Auswahl: ";
				int opt=0;
				cin>>opt;
				//create and change the are so that it is a valid space univers
				area=univ.getNeigbours(area.front(), dist);
				cout<<"Punkte im Bereich: "<<area.size()<<" positive Distanzen: "<<univ.getNumberOfPosDistances(area);
				cout<<" negative Distanzen: "<<univ.getNumberOfNegDistances(area)<<endl<<flush;
				list<cPoint*>::iterator itr1,itr2,itr3;
				if(opt&&(opt<5))
				{
					switch (opt){
						case 1://delete negattiv distances of the area
							for(list<cPoint*>::iterator itr=area.begin();itr!=area.end();itr++){
								itr2=(*itr)->nPoint.begin();
								for(;itr2!=(*itr)->nPoint.end();itr2++){
									for (itr3=(*itr2)->nPoint.begin();itr3!=(*itr2)->nPoint.end();itr3++)
											{if((*itr)==(*itr3)){break;}}
									(*itr2)->nPoint.erase(itr3);
									(*itr)->nPoint.erase(itr2);
									itr2=(*itr)->nPoint.begin();
								}
							}
						break;
						case 2://delete positiv distances of the area
							for(list<cPoint*>::iterator itr=area.begin();itr!=area.end();itr++){
								itr2=(*itr)->pPoint.begin();
								for(;itr2!=(*itr)->pPoint.end();itr2++){
									for (itr3=(*itr2)->pPoint.begin();itr3!=(*itr2)->pPoint.end();itr3++)
											{if((*itr)==(*itr3)){break;}}
									(*itr2)->pPoint.erase(itr3);
									(*itr)->pPoint.erase(itr2);
									itr2=(*itr)->pPoint.begin();
								}
							}
						break;
						case 3://change negativ distances in the area to positiv distances
							for(list<cPoint*>::iterator itr=area.begin();itr!=area.end();itr++){
								itr2=(*itr)->nPoint.begin();
								for(;itr2!=(*itr)->nPoint.end();itr2++){
									for (itr3=(*itr2)->nPoint.begin();itr3!=(*itr2)->nPoint.end();itr3++)
											{if((*itr)==(*itr3)){break;}}
									(*itr2)->nPoint.erase(itr3);
									(*itr2)->pPoint.push_back(*itr);
									(*itr)->pPoint.push_back(*itr2);
									(*itr)->nPoint.erase(itr2);
									itr2=(*itr)->nPoint.begin();
								}
							}
						break;
						case 4://change positiv distances in the area to negativ distances
							for(list<cPoint*>::iterator itr=area.begin();itr!=area.end();itr++){
								itr2=(*itr)->pPoint.begin();
								for(;itr2!=(*itr)->pPoint.end();itr2++){
									for (itr3=(*itr2)->pPoint.begin();itr3!=(*itr2)->pPoint.end();itr3++)
											{if((*itr)==(*itr3)){break;}}
									(*itr2)->pPoint.erase(itr3);
									(*itr2)->nPoint.push_back(*itr);
									(*itr)->nPoint.push_back(*itr2);
									(*itr)->pPoint.erase(itr2);
									itr2=(*itr)->pPoint.begin();
								}
							}
						break;
					}
				}
				if(opt<5) {
					unsigned long marker=area.front()->tmpValue;//every point in the area has a tmpValue of marker;
					long posErased=0,negErased=0,posChanged=0,negChanged=0, diffPos=0,diffNeg=0;
						//becaus of area=univ.getNeigbours(area.front(), dist);
					//change neibour points so that all points have neibours in the area
					list<TripelcPoint*> tPoint;
					list<TripelcPoint*> tPointDone;
					TripelcPoint *tmpTP;
					//find distaces without positiv neibous in the area
					for(itr1=area.begin();itr1!=area.end();itr1++){
						for(itr2=(*itr1)->pPoint.begin();itr2!=(*itr1)->pPoint.end();itr2++){
							if((*itr2)->tmpValue!=marker)//if the neibour is not in the area add to tPoint
							{
								tmpTP=new TripelcPoint();
								tmpTP->inPoint=(*itr1);//point from wich the distance goes
								tmpTP->nboPInDistances=(*itr1)->pPoint.size();
								tmpTP->nboNInDistances=(*itr1)->nPoint.size();
								tmpTP->outPoint=(*itr2);//point to wich the distance goes
								tmpTP->nboPOutDistances=(*itr2)->pPoint.size();
								tmpTP->nboNOutDistances=(*itr2)->nPoint.size();
								tmpTP->altPoint=0;//alternitiv point
								tmpTP->differenceOutAlt=maxDiff;
								tPoint.push_back(tmpTP);
							}
						}
					}
					if(tPoint.size()&1){//if the number of distances is odd delete one
						tmpTP=tPoint.front();
						for(itr1=(tmpTP->inPoint)->pPoint.begin();itr1!=(tmpTP->inPoint)->pPoint.end();itr1++){
							if((*itr1)->tmpValue!=marker){
								(tmpTP->inPoint)->pPoint.erase(itr1);
								posErased++;
								diffPos+=tmpTP->nboPInDistances;
								diffNeg+=tmpTP->nboNInDistances;
								break;
							}
						}
						tPoint.pop_front();
					}
					list<TripelcPoint*>::iterator itrTP1,itrTP2,itrTP3;
					long tmpDiff1,tmpDiff2,tmpDiff3,tmpDiff4;
					bool change=true;
					//initialisize all alternativ points with values
					//set itrTP1 to the beginning and itrTP2 to the middle of tPoint
					tmpDiff1=tPoint.size()>>1;//tmpDiff1=tPoint.size()/2
					itrTP2=tPoint.begin();
					for(;tmpDiff1!=0;tmpDiff1--){itrTP2++;}
					for(itrTP1=tPoint.begin();itrTP2!=tPoint.end();itrTP1++,itrTP2++)
					{
						if(((*itrTP1)->inPoint)!=((*itrTP2)->inPoint)){
							tmpDiff1=(*itrTP1)->getDiffernce(**itrTP2);
							tmpDiff2=(*itrTP2)->getDiffernce(**itrTP1);
							(*itrTP1)->altPoint=(*itrTP2);
							(*itrTP1)->differenceOutAlt=tmpDiff1;
							(*itrTP2)->altPoint=(*itrTP1);
							(*itrTP2)->differenceOutAlt=tmpDiff2;
						}
					}
					for(itrTP1=tPoint.begin();itrTP1!=tPoint.end();itrTP1++)
					{//delete point without alternitiv points
						if((*itrTP1)->altPoint==0){//if the number of distances is odd delete one
							for(itr1=((*itrTP1)->inPoint)->pPoint.begin();itr1!=((*itrTP1)->inPoint)->pPoint.end();itr1++){
								if((*itr1)->tmpValue!=marker){
									((*itrTP1)->inPoint)->pPoint.erase(itr1);
									posErased++;
									diffPos+=tmpTP->nboPInDistances;
									diffNeg+=tmpTP->nboNInDistances;
									break;
								}
							}
							itrTP1=tPoint.erase(itrTP1);
							itrTP1--;
						}
					}
					while((change)&&(!tPoint.empty())){
						change=false;
						cout<<"Positive Distanzen zum Pruefen: "<<tPoint.size()<<" Erledigt: "<<tPointDone.size()<<endl<<flush;
						for(itrTP1=tPoint.begin();itrTP1!=tPoint.end();itrTP1++){
							itrTP2=itrTP1;itrTP2++;
							for(;itrTP2!=tPoint.end();itrTP2++)
							{
								if((((*itrTP1)->inPoint)!=((*itrTP2)->inPoint))
									&&((((*itrTP1)->altPoint)->inPoint)!=(((*itrTP2)->altPoint)->inPoint)))
								{
	//								cout<<"1"<<flush;
	
									tmpDiff1=(*itrTP1)->getDiffernce(**itrTP2);
									tmpDiff2=(*itrTP2)->getDiffernce(**itrTP1);
									tmpDiff3=((*itrTP1)->altPoint)->getDiffernce(*((*itrTP2)->altPoint));
									tmpDiff4=((*itrTP2)->altPoint)->getDiffernce(*((*itrTP1)->altPoint));
									if((*itrTP1)->differenceOutAlt+(*itrTP2)->differenceOutAlt
										+(((*itrTP1)->altPoint)->differenceOutAlt)+(((*itrTP2)->altPoint)->differenceOutAlt)
										>tmpDiff1+tmpDiff2+tmpDiff3+tmpDiff4)
									{//flip conections
										((*itrTP1)->altPoint)->altPoint=((*itrTP2)->altPoint);
										((*itrTP1)->altPoint)->differenceOutAlt=tmpDiff3;
										((*itrTP2)->altPoint)->altPoint=((*itrTP1)->altPoint);
										((*itrTP2)->altPoint)->differenceOutAlt=tmpDiff4;
										if((tmpDiff3==0)&&(tmpDiff4==0)){
											tPointDone.push_back(((*itrTP1)->altPoint));
											tPointDone.push_back(((*itrTP2)->altPoint));
											for(itrTP3=tPoint.begin();itrTP3!=tPoint.end();itrTP3++)
												{if(((*itrTP1)->altPoint)==(*itrTP3)){break;}}
											tPoint.erase(itrTP3);
											for(itrTP3=tPoint.begin();itrTP3!=tPoint.end();itrTP3++)
												{if(((*itrTP2)->altPoint)==(*itrTP3)){break;}}
											tPoint.erase(itrTP3);
										}
										(*itrTP1)->altPoint=(*itrTP2);
										(*itrTP1)->differenceOutAlt=tmpDiff1;
										(*itrTP2)->altPoint=(*itrTP1);
										(*itrTP2)->differenceOutAlt=tmpDiff2;
										if((tmpDiff1==0)&&(tmpDiff2==0)){
											tPointDone.push_back(*itrTP1);
											tPointDone.push_back(*itrTP2);
											tPoint.erase(itrTP2);
											itrTP1=tPoint.erase(itrTP1);
											itrTP2=itrTP1;itrTP1--;
										}
										change=true;
	//									cout<<"2"<<flush;
	
									}
								}
							}
						}
					}
	
	
					//change area
					while(!tPoint.empty()){
						tPointDone.push_back(*(tPoint.begin()));
						tPoint.pop_front();
					}
					while(!tPointDone.empty()){
						tmpTP=tPointDone.front();
						for(itr1=(tmpTP->outPoint)->pPoint.begin();itr1!=(tmpTP->outPoint)->pPoint.end();itr1++){
							if((*itr1)==(tmpTP->inPoint)){
								(tmpTP->outPoint)->pPoint.erase(itr1);
								break;
							}
						}
						if((tmpTP->altPoint)==0){//if ther is no alternitiv point, erase distance
							for(itr1=(tmpTP->inPoint)->pPoint.begin();itr1!=(tmpTP->inPoint)->pPoint.end();itr1++){
								if((*itr1)->tmpValue!=marker){
									(tmpTP->inPoint)->pPoint.erase(itr1);
									posErased++;
									diffPos+=tmpTP->nboPInDistances;
									diffNeg+=tmpTP->nboNInDistances;
									break;
								}
							}
						}else{
							for(itr1=(tmpTP->inPoint)->pPoint.begin();itr1!=(tmpTP->inPoint)->pPoint.end();itr1++){
								if((*itr1)->tmpValue!=marker){
									(tmpTP->inPoint)->pPoint.erase(itr1);
									(tmpTP->inPoint)->pPoint.push_back((tmpTP->altPoint)->inPoint);
									posChanged++;
									diffPos+=absL(tmpTP->nboPInDistances-(tmpTP->altPoint)->nboPInDistances);
									diffNeg+=absL(tmpTP->nboNInDistances-(tmpTP->altPoint)->nboNInDistances);
									break;
								}
							}
						}
						tPointDone.pop_front();
					}
	
	
					//find distaces without negativ neibous in the area
					for(itr1=area.begin();itr1!=area.end();itr1++){
						for(itr2=(*itr1)->nPoint.begin();itr2!=(*itr1)->nPoint.end();itr2++){
							if((*itr2)->tmpValue!=marker)//if the neibour is not in the area add to tPoint
							{
								tmpTP=new TripelcPoint();
								tmpTP->inPoint=(*itr1);//point from wich the distance goes
								tmpTP->nboPInDistances=(*itr1)->pPoint.size();
								tmpTP->nboNInDistances=(*itr1)->nPoint.size();
								tmpTP->outPoint=(*itr2);//point to wich the distance goes
								tmpTP->nboPOutDistances=(*itr2)->pPoint.size();
								tmpTP->nboNOutDistances=(*itr2)->nPoint.size();
								tmpTP->altPoint=0;//alternitiv point
								tmpTP->differenceOutAlt=maxDiff;
								tPoint.push_back(tmpTP);
							}
						}
					}
					if(tPoint.size()&1){//if the number of distances is odd delete one
						tmpTP=tPoint.front();
						for(itr1=(tmpTP->inPoint)->nPoint.begin();itr1!=(tmpTP->inPoint)->nPoint.end();itr1++){
							if((*itr1)->tmpValue!=marker){
								(tmpTP->inPoint)->nPoint.erase(itr1);
								negErased++;
								diffPos+=tmpTP->nboPInDistances;
								diffNeg+=tmpTP->nboNInDistances;
								break;
							}
						}
						tPoint.pop_front();
					}
	
					//initialisize all alternativ points with values
					//set itrTP1 to the beginning and itrTP2 to the middle of tPoint
					tmpDiff1=tPoint.size()>>1;//tmpDiff1=tPoint.size()/2
					itrTP2=tPoint.begin();
					for(;tmpDiff1!=0;tmpDiff1--){itrTP2++;}
					for(itrTP1=tPoint.begin();itrTP2!=tPoint.end();itrTP1++,itrTP2++)
					{
						if(((*itrTP1)->inPoint)!=((*itrTP2)->inPoint)){
							tmpDiff1=(*itrTP1)->getDiffernce(**itrTP2);
							tmpDiff2=(*itrTP2)->getDiffernce(**itrTP1);
							(*itrTP1)->altPoint=(*itrTP2);
							(*itrTP1)->differenceOutAlt=tmpDiff1;
							(*itrTP2)->altPoint=(*itrTP1);
							(*itrTP2)->differenceOutAlt=tmpDiff2;
						}
					}
					for(itrTP1=tPoint.begin();itrTP1!=tPoint.end();itrTP1++)
					{//delete point without alternitiv points
						if((*itrTP1)->altPoint==0){//if the number of distances is odd delete one
							for(itr1=((*itrTP1)->inPoint)->nPoint.begin();itr1!=((*itrTP1)->inPoint)->nPoint.end();itr1++){
								if((*itr1)->tmpValue!=marker){
									((*itrTP1)->inPoint)->nPoint.erase(itr1);
									negErased++;
									diffPos+=tmpTP->nboPInDistances;
									diffNeg+=tmpTP->nboNInDistances;
									break;
								}
							}
							itrTP1=tPoint.erase(itrTP1);
							itrTP1--;
						}
					}
					change=true;
					while((change)&&(!tPoint.empty())){
						change=false;
						cout<<"Negative Distanzen zum Pruefen: "<<tPoint.size()<<" Erledigt: "<<tPointDone.size()<<endl<<flush;
						for(itrTP1=tPoint.begin();itrTP1!=tPoint.end();itrTP1++){
							itrTP2=itrTP1;itrTP2++;
							for(;itrTP2!=tPoint.end();itrTP2++)
							{
								if((((*itrTP1)->inPoint)!=((*itrTP2)->inPoint))
									&&((((*itrTP1)->altPoint)->inPoint)!=(((*itrTP2)->altPoint)->inPoint)))
								{
									tmpDiff1=(*itrTP1)->getDiffernce(**itrTP2);
									tmpDiff2=(*itrTP2)->getDiffernce(**itrTP1);
									tmpDiff3=((*itrTP1)->altPoint)->getDiffernce(*((*itrTP2)->altPoint));
									tmpDiff4=((*itrTP2)->altPoint)->getDiffernce(*((*itrTP1)->altPoint));
									if((*itrTP1)->differenceOutAlt+(*itrTP2)->differenceOutAlt
										+(((*itrTP1)->altPoint)->differenceOutAlt)+(((*itrTP2)->altPoint)->differenceOutAlt)
										>tmpDiff1+tmpDiff2+tmpDiff3+tmpDiff4)
									{//flip conections
										((*itrTP1)->altPoint)->altPoint=((*itrTP2)->altPoint);
										((*itrTP1)->altPoint)->differenceOutAlt=tmpDiff3;
										((*itrTP2)->altPoint)->altPoint=((*itrTP1)->altPoint);
										((*itrTP2)->altPoint)->differenceOutAlt=tmpDiff4;
										if((tmpDiff3==0)&&(tmpDiff4==0)){
											tPointDone.push_back(((*itrTP1)->altPoint));
											tPointDone.push_back(((*itrTP2)->altPoint));
											for(itrTP3=tPoint.begin();itrTP3!=tPoint.end();itrTP3++)
												{if(((*itrTP1)->altPoint)==(*itrTP3)){break;}}
											tPoint.erase(itrTP3);
											for(itrTP3=tPoint.begin();itrTP3!=tPoint.end();itrTP3++)
												{if(((*itrTP2)->altPoint)==(*itrTP3)){break;}}
											tPoint.erase(itrTP3);
										}
										(*itrTP1)->altPoint=(*itrTP2);
										(*itrTP1)->differenceOutAlt=tmpDiff1;
										(*itrTP2)->altPoint=(*itrTP1);
										(*itrTP2)->differenceOutAlt=tmpDiff2;
										if((tmpDiff1==0)&&(tmpDiff2==0)){
											tPointDone.push_back(*itrTP1);
											tPointDone.push_back(*itrTP2);
											tPoint.erase(itrTP2);
											itrTP1=tPoint.erase(itrTP1);
											itrTP2=itrTP1;itrTP1--;
										}
										change=true;
									}
								}
							}
						}
					}
					//change area
					while(!tPoint.empty()){
						tPointDone.push_back(*(tPoint.begin()));
						tPoint.pop_front();
					}
					while(!tPointDone.empty()){
						tmpTP=tPointDone.front();
						for(itr1=(tmpTP->outPoint)->nPoint.begin();itr1!=(tmpTP->outPoint)->nPoint.end();itr1++){
							if((*itr1)==(tmpTP->inPoint)){
								(tmpTP->outPoint)->nPoint.erase(itr1);
								break;
							}
						}
						if((tmpTP->altPoint)==0){//if ther is no alternitiv point, erase distance
							for(itr1=(tmpTP->inPoint)->nPoint.begin();itr1!=(tmpTP->inPoint)->nPoint.end();itr1++){
								if((*itr1)->tmpValue!=marker){
									(tmpTP->inPoint)->nPoint.erase(itr1);
									negErased++;
									diffPos+=tmpTP->nboPInDistances;
									diffNeg+=tmpTP->nboNInDistances;
									break;
								}
							}
						}else{
							for(itr1=(tmpTP->inPoint)->nPoint.begin();itr1!=(tmpTP->inPoint)->nPoint.end();itr1++){
								if((*itr1)->tmpValue!=marker){
									(tmpTP->inPoint)->nPoint.erase(itr1);
									(tmpTP->inPoint)->nPoint.push_back((tmpTP->altPoint)->inPoint);
									negChanged++;
									diffPos+=absL(tmpTP->nboPInDistances-(tmpTP->altPoint)->nboPInDistances);
									diffNeg+=absL(tmpTP->nboNInDistances-(tmpTP->altPoint)->nboNInDistances);
									break;
								}
							}
						}
						tPointDone.pop_front();
					}
	
	
					ofstream outFile(uPfad);
					if(outFile){
						if(univ.printUniverseStructur(&outFile, area)){
							cout<<endl<<endl<<"Vorgang erfolgreich ausgefuehrt!"<<endl;
							cout<<"Das neue Raumuniversum hat Punkte: "<<area.size()<<" positive Distanzen: ";
							cout<<univ.getNumberOfPosDistances(area)<<" negative Distanzen: "<<univ.getNumberOfNegDistances(area)<<endl;
							cout<<"Positive Distanzen geloesch : "<<posErased<<endl;
							cout<<"Negative Distanzen geloesch : "<<negErased<<endl;
							cout<<"Positive Distanzen versetzt: "<<posChanged<<" Differnz positiv Distanzen : "<<diffPos<<endl;
							cout<<"Negative Distanzen versetzt: "<<negChanged<<" Differnz negativ Distanzen : "<<diffNeg<<endl;
						}
						outFile.close();
					}
				}
			}
			cout<<endl<<"Weiteren Bereich ausschneiden? (J/N) "<<flush;
			cin>>uPfad;
			if (!((uPfad[0]=='Y')||(uPfad[0]=='J')||(uPfad[0]=='1')||(uPfad[0]=='W')||(uPfad[0]=='O')
				||(uPfad[0]=='y')||(uPfad[0]=='j')||(uPfad[0]=='w')||(uPfad[0]=='o')))
				{delete [] uPfad;return 0;}
		}
		}else{cout<<endl<<endl<<"Ungueltige Datei!"<<endl;}
	}else{cout<<endl<<endl<<"Ungueltiger Pfad!"<<endl;}
	delete [] uPfad;
	return 0;
}








