/*File Name: cPoint.h
  Author: Betti Oesterholz ; Date: 04.04.2007
  System: C++


  Copyright (C) 2007  Betti Oesterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <iostream>
#include <list>

#ifndef ___TPOINT_h__
#define ___TPOINT_h__

#define UNIVERS_TYP "univers"

using std::ostream;
using std::list;

class cPoint{//links to cells/nodes
//class of the univers points
public:
	unsigned long name;//name of the point
	list<cPoint*> pPoint;//positv neibors
	list<cPoint*> nPoint;//negativ neibors

	unsigned long tmpValue;/*this variable helps to spead up the algorithm,
		be carefull if you change this, the value of this variable should
		always be smale as the tmpValue of the univers*/

	unsigned int posNeibours;//number of positiv neibours
	unsigned int negNeibours;//number of positiv neibours
	unsigned long transPosible;//posible transitions

	cPoint();
	/*standart constructor*/

	cPoint(cPoint &poi);
	/*copy constructor*/

	unsigned long getTransPosible();
	/*returns the evalued posible transitions for this point and set the
	value transPosible of this point*/

	bool operator<(const cPoint tpoi) const;
	/*the lower realtion for cPoint
	pre: two cPoint
	post: true if the name of the first cPoint of the first is lower
		then the secound, else false*/

	bool operator==(cPoint &tpoi);
	/*the equal realtion for cPoint
	pre: two cPoint
	post: true if the tPoints have the same name and same neibours( equal of 
	neibours are checkt by ther names; if they have same names ther are equal)
	in the same amount and kind(positiv or negativ), false else*/

	friend ostream &operator<<(ostream &ostream, cPoint &tpoi);

	bool static lower(const cPoint* tpoi1,const cPoint* tpoi2);
	/*the lower realtion for cPoint pointers
	pre: two cPoint pointers
	post: true if the name of the first cPoint of the first pointer is lower
		then the secound, else false*/

};
 
#endif

