/*File Name: cUniversNeib.h
  Author: Betti Oesterholz ; Date: 12.04.2005
  System: C++


  Copyright (C) 2004  Betti oesterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 This file contains tools for the univers.
*/

#non tested

	cUniversNeib(char* parFN="standart_Parameter.txt");
	/*this constructor constructs a new instanz of this objekt with the
	parameter of the parameters in the parameterfile with the path parFN
	pre: the name or path parFN of the parameterfile with the parameter to load
	post: the instanze of this object with the parameter of the parameter file*/

	cUniversNeib(bool outC, unsigned long cutA=0, unsigned long mTm=100, unsigned long maxP=0, unsigned long cMP=1, char* stat="./statistic/statistics.txt", char* uFol="./universen/", char* bUN="univers", double cutDim=3.0, double cutRatio=1.0, unsigned long gAP=1000, unsigned long gD=1 , unsigned long gP=100, double grSP=0.0, char* statFoldN="./statistik/", unsigned long getDirc=1,char* directBN="grid", unsigned long getD=0, char* distBN="dist", unsigned long getN=1, unsigned int nGD=2, char* neibBN="neib", bool getPS=0, char* partN="./partsize.txt");/*:
		cUnivers(outC,cutA,mTm,maxP ,cMP,stat,uFol,bUN ,cutDim ,cutRatio),
		gridDist(gD),gridPoints(gP),gridAfterPoints(gAP),neibDist(nGD),
		,getDist(getD),getNeib(getN),statisticFolderName(statFoldName),distBaseName(distBN),neibBaseName(neibBN),
		gridStartPoint(grSP)*/
	/*parameter constructor, constructs a new univers with standart values
	beware this constructor copies just the char* pointers, but not the string in them!
	parameters: output comments outC,cut after cutA steps (cutA),number of maximal
	ticks mTm, maximal number of Points maxP, name of the statistic file,
	cutDim the dimension to prefer by cut cutNearDimension, cutRatio the Ratio
	till wich to generate the max class by cut cutMaxClassRatio, gAP is the
	number of points the univers should have before the grid is created,
	gD is the distance the points in the initial (first) grid should have,
	gP are the number of points the initial grid should have,
	nGD is the distance till wich the number of neibours of the grid should be evalued,
	every getDirc ticks the direct statistics are evalued and outputed,
	every getD ticks is true the distance statistics are evalued and outputed,
	every getN ticks is true the neibours statistics are evalued and outputed,
	statFoldN is the name of the folder for distance and neibour statistics,
	directBaseName(directBN), distBaseName(distBN),neibBaseName(neibBN),
		gridStartPoint(grSP),getPartSize(getPS)
	if some every tick is 0 then the statistic is never evalues


	in a tick all ponts of the univers are changed once
	standart statistic file is: "./statistics.txt"
	the grid is a list of points with wich the statistic data of the distances
	and neibours are evalued
	if the maximal number is reached, the actual tick is the last*/

	cUniversNeib(cUniversNeib &uNeib);
	/*copy constructor, constructs a copy of the given univers uNeib;
	file output cycles will be set to 0
	pre: the univers to copy*/

	~cUniversNeib();
	/*standart destructor
	destructs the univers and closes all open files of the univers*/

	list<unsigned long> getGridNames() const {return gridN;}
	/*returns a list of the names of the points in the grid
	post: a list with the unsigned long names of the points in the grid*/

	unsigned long getGridDistance() const {return gridDist;}
	/*returns the minimal distance the grid points should have when the grid is
	created
	post: the minimal initial distance betwean the grid points*/

	unsigned long getNumberOfGridPoints() const {return gridPoints;}
	/*returns the number of points the grid should have when it is created
	post: the initial number of points in the grid grid*/

	unsigned long getGridAfterPoints() const {return gridAfterPoints;}
	/*get the number of points the univers should have before the grid is created
	post: the minimal number of points after wich the univers should be created*/

	unsigned long getNeibourDistance() const {return neibDist;}
	/*returns the distance till wich the neibours should be evalued
	post: the distance till wich the neibours should be evalued*/

	unsigned long getDirectStatistics() const {return getDirect;}
	/*returns if the direct statistic schould be evalued
	post: how often the direct statistic should be evalued, if 0 don't evalue*/

	unsigned long getPartSizeStatistics() const {return getPartSize;}
	/*returns how often the size of the part statistic schould be evalued
	post: how often the size of the part statistic should be evalued, if 0 don't evalue*/

	unsigned long getDistanceStatistics() const {return getDist;}
	/*returns if the distance statistic schould be evalued
	post:  how often the distance statistic should be evalued, if 0 don't evalue*/

	unsigned long getNeibourStatistics() const {return getNeib;}
	/*returns if the neibour statistic schould be evalued
	post:  how often the neibour statistic should be evalued, if 0 don't evalue*/

	char* getStatisticFolderName() const {return statisticFolderName;}
	/*returns the folder/path name in wich the statistics should be saved
	post: the pointer to folder/path name in wich the statistics should be
		saved, beware: this method dosn't copy the string*/

	char* getDirectBaseFileName() const {return directBaseName;}
	/*returns the base name of the direct statistic files
	post: the pointer to base name of the direct statistic files
		beware: this method dosn't copy the string*/

	char* getPartSizeFileName() const {return partSizeName;}
	/*returns the name of the part size statistic file
	post: the pointer to name of the part size statistic file
		beware: this method dosn't copy the string*/

	char* getDistanceBaseFileName() const {return distBaseName;}
	/*returns the base name of the distance statistic files
	post: the pointer to base name of the distance statistic files
		beware: this method dosn't copy the string*/

	char* getNeibourBaseFileName() const {return neibBaseName;}
	/*returns the base name of the neibour statistic files
	post: the pointer to base name of the neibour statistic files
		beware: this method dosn't copy the string*/

	double getGridStartPoint() const {return gridStartPoint;}
	/*returns wher the start point of the grid in the univers should be,
	0 the grid should begin with univers first point, 1 grid should begin with
	univers last point
	post: the number wher the start point of the grid in the univers should be*/

	void setGridNames(const list<unsigned long> grN) {gridN=grN;}
	/*sets the list of the names of the points in the grid to the given list
	of point names; overwrites the old grid
	pre: a list with the unsigned long names of the points the grid should consit of*/

	void setGridDistance(const unsigned long grD) {gridDist=grD;}
	/*set the minimal distance the grid points should have when the grid is
	created, if the grid is not created already
	pre: the minimal initial distance betwean the grid points
	post: true if the minimal distance is set to the value (when the grid is
		not created), else false*/

	void setNumberOfGridPoints(const unsigned long grP) {gridPoints=grP;}
	/*set the number of points the grid should have when the grid is created,
	if the grid is not created already
	pre: the number of points the grid should have
	post: true if the number of initial grid points is set to the value (when
		the grid is not created), else false*/

	bool setGridAfterPoints(const unsigned long grAP) 
	/*set the minimal number of points the univers should have when the grid is created,
	if the grid is not created already
	pre: the number of points the univers should have when the grid is created
	post: true if the minimal number of univers points to create a grid is set
		to the value (when the grid is not created), else false*/
	{gridAfterPoints=grAP;
	return true;}

	bool setDirectStatistics(const unsigned long gDirc);
	/*set how often the direct statistic schould be evalued and opens the all
	direct file if it needs to
	pre: after how much ticks the direct statistic should be evalued (if 0
		don't evalue)
	post: true if the value is changed, else false*/

	bool setGetPartSize(const unsigned long pSize);
	/*set how often the maximal distance from the grid start point should be evalued
	pre: after how much ticks the maximal distance from the grid start point
		should be evalued (if 0 don't evalue)
	post: true if the value is changed, else false*/

	bool setDistanceStatistics(const unsigned long gDist);
	/*set how often the distance statistic schould be evalued and opens the all
	dist file if it needs to (if 0 don't evalue)
	pre: after how much ticks the distance statistic should be evalued (if 0
		don't evalue)
	post: true if the value is changed, else false*/

	bool setNeibourStatistics(const unsigned long gNeib);
	/*set how often the neibour statistic schould be evalued and opens the all
	neib file if it needs to (if 0 don't evalue)
	pre: after how much ticks the neibour statistic should be evalued (if 0
		don't evalue)
	post: true if the value is changed, else false*/

	bool setNeibourDistance(const unsigned long neibD);
	/*set the distance till wich the neibours should be evalued
	pre: the distance till wich the neibours should be evalued
	post: true if the value is changed, else false*/

	bool setStatisticFolderName(char* statFN);
	/*set the folder/path name in wich the statistics should be saved and
	creats the new files for all statistics in theas directorys/paths
	(beware old files are with the new name are overwriten)
	post: the pointer to folder/path name in wich the statistics should be
		saved
	post: true if the value is changed, else false*/

	bool setDirectBaseFileName(char* dircBN);
	/*set the direct base file name in wich the direct statistics should be saved and
	creats the new file for all direct statistics in theas files
	post: the pointer to direct base file name in wich the direct statistics should be
		saved
	post: true if the value is changed, else false*/

	bool setPartSizeFileName(char* partN);
	/*set the partsize file name in wich the part size of the actual univers
	should be saved and creats the new file for part size statistics
	post: the pointer to partsize file name in wich the partsize statistics
		should be saved
	post: true if the value is changed, else false*/

	bool setDistanceBaseFileName(char* distBN);
	/*set the distance base file name in wich the distance statistics should be saved and
	creats the new file for all distance statistics in theas files
	post: the pointer to distance base file name in wich the distance statistics should be
		saved
	post: true if the value is changed, else false*/

	bool setNeibourBaseFileName(char* neibBN);
	/*set the neibour base file name in wich the neibour statistics should be saved and
	creats the new file for all neibour statistics in theas files
	post: the pointer to neibour base file name in wich the neibour statistics should be
		saved
	post: true if the value is changed, else false*/

	bool setGridStartPoint(const double grSP);
	/*set wher the grid start points in the univers should be,
	if the grid is not created already, 0 the grid should begin with univers
	first point, 1 grid should begin with univers last point
	pre: the number wher grid start point in the univers should be
	post: true if the wher grid start point in the univers should be is set
		to the value (when the grid is not created), else false*/

	bool restoreGrid(const char* gFile);
	/*loads the grid (list of point names) from the file with the
	pathname gFile
	pre: the pathname of the grid file
	post: the loaded grid in this class instanze*/

	bool storeGrid(const char* gFile);
	/*writes the grid (list of point names) to the file with the pathname
	gFile
	pre: the pathname of the grid file
	post: the stored grid in the file*/

	bool restoreParameter(const char* pFile);
	/*loads the parameter from the file with the pathname pFile
	pre: the pathname of the parameter file
	post: the loaded parameter in this class instanze*/

	bool storeParameter(const char* pFile);
	/*writes the parameter to the file with the pathname pFile
	pre: the pathname of the parameter file
	post: the stored parameter in the file*/

	void printDirectGridHead();
	/*prints the head of the direct all tabel */

	void printStatisticNeibourGridHead();
	/*prints the head of the neibour all tabel */

	void printStatisticDistGridHead();
	/*prints the head of the dist all tabel */

	void evalueGridDistance(list<cPoint*> grid);
	/*evaluates the distance betwean the grid points and output them to the distance files
	pre: the grid for wich the statistics should be evalued*/

	void evalueGridNeibour(list<cPoint*> grid);
	/*evalue the neibourhood of the grid points till neibDist distance
	pre: the grid for wich the statistics should be evalued*/

	void evalueDirectStatGrid(list<cPoint*> grid);
	/*evalue the statistics of the grid, for each point in the grid the number of all, positiv, negativ, (positiv-negativ) distances and neibour points is printed
	pre: the grid for wich the statistics should be evalued*/

	void evaluePartSize();
	/*get the size of the Part univers in wich the Point orgin is to the point orgin,
	this means the greatest minimal distance to a point in the part univers*/

	bool outputCondition();
	/*evaluates if the actual univers should be outputed
	post: true if the univers should be outputed; else false*/
	
	bool endCondition() const;
	/*Evalues the end condition for the univers. Means when the evaluation of
	the univers is stoped.
	case 1: the time iTime is higer than the maximum number of ticks(maxTime,
		maxTime=0 -> inf) or (the number of points should be checked (it is the
		checkMaxPoints tick) and it is higher then the maximal number of points
		(maxPoints, maxPoints=0 -> inf))
	post: true if the end condition holds and the univers should be stoped,
		else false*/

	void start(unsigned long trans=0);
	/*Starts the evaluation of the univers. Makes ticks till the end condition
	holds.
	post: the this univers changed*/


