/*File Name: cUniversTools.h
  Author: Betti Oesterholz ; Date: 12.01.2005
  System: C++


  Copyright (C) 2004  Betti Oesterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 This file contains tools for the univers.
*/


#non tested

	cUniversTools():cUnivers(){}
	/*standart constructor, constructs a new univers with standart values
	standart statistic file is: "./statistics.txt"*/

	cUniversTools(bool outC,unsigned int cutA=0,unsigned long mTm=100, unsigned long maxP=0, unsigned int cMP=1,char* stat="./statistics.txt",char* uFol="./universes/", char* bUN="univers",double cutDim=3.0,double cutRatio=1.0):
	cUnivers(outC ,cutA ,mTm,maxP ,cMP,stat,uFol,bUN ,cutDim ,cutRatio){}
	/*parameter constructor, constructs a new univers with standart values
	beware this constructor copies just the char* pointers, but not the string in them!
	parameters: output comments outC,cut after steps cutA,number of maxTime
	iter, name of the statistic file, the dimension to prefer by cut
	cutNearDimension ,the Ratio till wich to generate the max class by cut
	cutMaxClassRatio, check maxPoints condition every cMP (checkMaxPoints)
	ticks, standart statistic file is: "./statistics.txt"*/

	cUniversTools(cUniversTools &uTools):cUnivers(uTools){}
	/*copy constructor, constructs a copy of the given univers uTools
	pre: the univers to copy*/

	list<cPoint*> unionPointLists(list<cPoint*> poiL1, list<cPoint*> poiL2) const;
	/*unions two point lists
	doesn't copy univers points(copies just the pointers)
	pre: the two point lists to union
	post:the unioned point list*/

	list<cPoint*> intersectionPointLists(list<cPoint*> &poiL1, list<cPoint*> &poiL2) const;
	/*intersec two point lists
	doesn't copy univers points(copies just the pointers)
	pre: the two point lists to intersec
	post:the interseced point list*/

	bool intersectionPointListsIsEmpty(list<cPoint*>* poiL1, list<cPoint*>* poiL2) const;
	/*checks if the intersection of the two point lists is empty
	pre: the two point to check the intersection of
	post:true if the intersection would be empty, else false*/

	list<cPoint*> getPointsNotInPointLists(list<cPoint*> &poiL1, list<cPoint*> &poiL2) const;
	/*get the points of the point list poiL1 that are not in the point list poiL2
	doesn't copy univers points(copies just the pointers)
	pre: the two point lists
	post:the point list of points that are in poiL1 but not in poiL2*/

	bool printcUniverseStructur(ostream* ostream, list<cPoint*> &struc) const;
	/*prints the values of the given univers structur to the given output
	stream, if it exists
	pre: the outputstream ostream to print the univers to and the univers
		structur struc to print
	post: if the stream exists true and the given structur univers in the stream
		ostream in a readebel form(integer numbers seperated by ",",";" and "."),
		false else*/

	list<cPoint*> findPoints(list<unsigned long> &listOfPointNames);
	/*find the points with the names of the numbers in the given list and
	return a list of pointers to them(doesn't copy the points), if they
	exists
	pre: a list of integer names of the points to find
	post: a pionter list to the points found*/

	list<cPoint*> getNeigbours(cPoint* orgin, const unsigned int dist);
	/*get all neigbours in the univers of the point orgin till the distantce dist
	doesn't copy univers points(copies just the pointers)
	negativ and positiv distances are treated equal
	pre: the original orgin point to get the neibours from and the distance till
		wich to get the neibours
	post: a list of pointers to the neibours till distance dist of the orgin point*/

	list<cPoint*> getMinNeigbours(cPoint* orgin, const unsigned int dist);
	/*get all neigbours in the univers of the point orgin with the minimum
	distantce dist to the point; doesn't copy univers points(copies just the
	pointers); negativ and positiv distances are treated equal
	pre: the original orgin point to get the neibours from and the distance till
		wich to get the neibours
	post: a list of pointers to the neibours with the distance dist to the orgin point*/

	long getDistance(cPoint* poi1, cPoint* poi2);
	/*gets the minimal distance(number af negativ and positiv distnaces betwean) betwean
	two Points in the univers; the points are given as iterators of the univers
	; negativ and positiv distances are treated equal; if the distance is -1
	the points are not conected
	pre: two iterators of the univers to two points in the univers
	post: the minimal distance of the points*/

	list<pair<cPoint*,long> > getDistanceToPoints(cPoint* poi1, list<cPoint*> &points);
	/*gets the minimal distance(number af negativ and positiv distnaces betwean) betwean
	the Point and the points of the point list in the univers;
	the point is given as iterator of the univers and the the points as a
	iteratorlist of iterators of the univers
	; negativ and positiv distances are treated equal
	pre: a iterator and a itorator list of the univers for the points in the
		univers
	post: the minimal distance of the points as a list of pairs of points and
		distances, if the distance is -1 the points are not conected*/


	unsigned int getcUniversPartSize(cPoint* orgin);
	/*get the size of the Part univers in wich the Point orgin is to the point orgin,
		this means the greatest minimal distance to a point in the part univers
	pre: the original orgin point to get the univers size to
	post: the greatest minimal distance a point has to the given orgin point*/

	list<cPoint*> getSurface(list<cPoint*> &poiL);
	/*gets the surface; the points of the given point list poiL that have
	neigbours not in the point list poiL
	doesn't copy univers points(copies just the pointers)
	pre: point list of wich to find the surface
	post: the surface of the given point list poiL*/

	list<cPoint*> makeGrid(cPoint* sPoi, const unsigned int dist, const unsigned int number);
	/*makes a grid of number nodes(if possible else less) with the startpoint
	sPoi and the minimum distance of dist betwean the points in this univers
	the grid is in its distances betwean the points not optimal(minimal)
	; negativ and positiv distances are treated equal
	pre: the startpoint sPoi for the grid as a pointer to a point of this
		univers, the number of points the grid should have and the minimum
		distance dist betwean them
	post: the points of the grid*/

	unsigned long getNumberOfPosDistances(list<cPoint*> &area);
	/*returns the number of the positv distances betwean the points in the
	given area of this univers
	pre: the area to evalue the positiv distances of
	post:  the number of positiv distances betwean the points of the area*/


	unsigned long getNumberOfNegDistances(list<cPoint*> &area);
	/*returns the number of the negativ distances betwean the points in the
	given area of this univers
	pre: the area to evalue the negativ distances of
	post: the number of negativ distances betwean the points of the area*/


