/*File Name: cPoint.cpp
  Author: Betti Oesterholz ; Date: 04.04.2007
  System: C++


  Copyright (C) 2007  Betti Oesterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "cPoint.h"

cPoint::cPoint():name(0),tmpValue(0),posNeibours(0),negNeibours(0),transPosible(1)
/*standart constructor*/
{}

cPoint::cPoint(cPoint &poi):name(poi.name),pPoint(poi.pPoint),nPoint(poi.nPoint),tmpValue(0)
/*copy constructor*/
{
getTransPosible();
}
	
unsigned long cPoint::getTransPosible()
/*returns the evalued posible transitions for tis point and set the
value transPosible of this point*/
{
pPoint.sort(&cPoint::lower);
nPoint.sort(&cPoint::lower);
//cout positiv neibours
posNeibours=0;
if(!pPoint.empty())
{
	posNeibours++;
	list<cPoint*>::iterator tItr=pPoint.begin();
	for (list<cPoint*>::iterator itr=pPoint.begin();itr!=pPoint.end();itr++){
		if((*tItr)!=(*itr)){
			posNeibours++;
			tItr=itr;
		}
	}
}
negNeibours=0;
if(!nPoint.empty())
{
	negNeibours++;
	list<cPoint*>::iterator tItr=nPoint.begin();
	for (list<cPoint*>::iterator itr=nPoint.begin();itr!=nPoint.end();itr++){
		if((*tItr)!=(*itr)){
			negNeibours++;
			tItr=itr;
		}
	}
}
transPosible=(posNeibours+negNeibours+1)*(posNeibours+negNeibours+1);
return transPosible;
}

bool cPoint::operator<(const cPoint tpoi) const
/*the lower realtion for cPoint
pre: two cPoint
post: true if the name of the first cPoint of the first is lower
	then the secound, else false*/
{return (name<tpoi.name);}


bool cPoint::operator==(cPoint &tpoi)
/*the equal realtion for cPoint
pre: two cPoint
post: true if the tPoints have the same name and same neibours( equal of 
neibours are checkt by ther names; if they have same names ther are equal)
in the same amount and kind(positiv or negativ), false else*/
{
//fast check: if the number of neibours don't have the same amount, the points are not equal
if ( ( pPoint.size()!= tpoi.pPoint.size() ) || 
     ( nPoint.size()!= tpoi.nPoint.size() )
   )
{
    return false;
}
//sort neibour points; if the points are sorted ther are easier to compare
pPoint.sort(&cPoint::lower);
nPoint.sort(&cPoint::lower);
tpoi.pPoint.sort(&cPoint::lower);
tpoi.nPoint.sort(&cPoint::lower);

//compare positiv neibours
if(!pPoint.empty())//same for poi becaus of fast check of neibour amount
{
	list<cPoint*>::iterator tItr1=pPoint.begin();
	list<cPoint*>::iterator tItr2=tpoi.pPoint.begin();
	for (;tItr1!=pPoint.end() && tItr2!=tpoi.pPoint.end();tItr1++,tItr2++)
	{
		if((*tItr1)->name!=(*tItr2)->name)
		{//not equal neibour found
			return false;
		}
	}
}
//compare negativ neibours
if(!nPoint.empty())//same for poi becaus of fast check of neibour amount
{
	list<cPoint*>::iterator tItr1=nPoint.begin();
	list<cPoint*>::iterator tItr2=tpoi.nPoint.begin();
	for (;tItr1!=nPoint.end() && tItr2!=tpoi.nPoint.end();tItr1++,tItr2++)
	{
		if((*tItr1)->name!=(*tItr2)->name)
		{//not equal neibour found
			return false;
		}
	}
}
return true;
}



bool cPoint::lower(const cPoint* tpoi1,const cPoint* tpoi2)
/*the lower realtion for cPoint pointers
pre: two cPoint pointers
post: true if the name of the first cPoint of the first pointer is lower
	then the secound, else false*/
{return ((tpoi1->name)<(tpoi2->name));}



 
