/**
 * file name: run.cpp
 * @author Betti Oesterholz
 * @date 17.11.2008
 * @mail webmaster@bernd-oesterholz.name
 *
 * System: C++
 *
 *
 * This file contains the main method to run the univers.
 * Copyright (C) @c GPL3 2008  Betti Oesterholz
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
/*
History:
17.11.2008  Oesterholz  created
*/

#include <iostream>
#include <cstdio>
#include <fstream>

#include "cUniversNeib.h"
//#include "cUnivers.cpp"
//#include "nReadValues.h"

using namespace std;


void printGPL(){

	cout<<"Copyright (C) @c GPL3 2008  Betti Oesterholz"<<endl<<endl;
	cout<<"This program is free software: you can redistribute it and/or modify"<<endl;
	cout<<"it under the terms of the GNU General Public License as published by"<<endl;
	cout<<"the Free Software Foundation, either version 3 of the License, or"<<endl;
	cout<<"any later version."<<endl;
	cout<<endl;
	cout<<"This program is distributed in the hope that it will be useful,"<<endl;
	cout<<"but WITHOUT ANY WARRANTY; without even the implied warranty of"<<endl;
	cout<<"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the"<<endl;
	cout<<"GNU General Public License for more details."<<endl;
	cout<<endl;
	cout<<"You should have received a copy of the GNU General Public License"<<endl;
	cout<<"along with this program. If not, see <http://www.gnu.org/licenses/>."<<endl;
}

int main(int argc,char* argv[]){

	printGPL();
	//cUniversNeib univ=cUniversNeib(true,1,1000,50000,1,"./statistics.txt","./universes/","univers",3.0,1.0,1000 ,3 ,30 ,0.0 ,"./statistic/" ,true,"direct",true ,"dist" ,true , 3,"neib",true);
		/*parameter constructor, constructs a new univers with standart values
		beware this constructor copies just the char* pointers, but not the string in them!
		parameters: output comments outC,cut after cutA steps (cutA),number of maximal
		ticks mTm, maximal number of Points maxP, name of the statistic file,
		cutDim the dimension to prefer by cut cutNearDimension, cutRatio the Ratio
		till wich to generate the max class by cut cutMaxClassRatio, gAP is the
		number of points the univers should have before the grid is created,
		gD is the distance the points in the initial (first) grid should have,
		gP are the number of points the initial grid should have,
		nGD is the distance till wich the number of neibours of the grid should be evalued,
		if getDirc is true the direct statistics are evalued and outputed,
		if getD is true the distance statistics are evalued and outputed,
		if getN is true the neibours statistics are evalued and outputed,
		statFoldN is the name of the folder for distance and neibour statistics,
		directBaseName(directBN), distBaseName(distBN),neibBaseName(neibBN),
			gridStartPoint(grSP),getPartSize(getPS)
	
	
		in a tick all ponts of the univers are changed once
		standart statistic file is: "./statistics.txt"
		the grid is a list of points with wich the statistic data of the distances
		and neibours are evalued
		if the maximal number is reached, the actual tick is the last*/
	
	cUniversNeib *univ;
	
	if(argc>1){
		cout<<"Parameterfile: "<<argv[1]<<endl;
		univ=new cUniversNeib( argv[1] );
	}else{
		univ=new cUniversNeib();
	}
	univ->start();
	
	delete univ;

	return 0;
}








