/*File Name: tcUniversEqual.cpp
  Author: Betti Oesterholz ; Date: 15.12.2007
  System: C++

  call: tcUniversEqual

  Description: This is the Tascase to check the equal Method of the class cUnivers.
  
  What's tested of class cUnivers: 
   - equal methods 
   

  Copyright (C) 2007  Betti Oesterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  History:

*/ 

#include <time.h>
#include <sys/stat.h>
#include <cstdlib>
#include <cstdio>

#include "cPoint.h"
#include "cUnivers.h"


using namespace std;


int testEqual1(unsigned long ulTestphase);
int testNotEqual1(unsigned long ulTestphase);
int testEqual2(unsigned long ulTestphase);
int testEqual3(unsigned long ulTestphase);
int testEqual4(unsigned long ulTestphase);



int main(int argc,char* argv[])
{
	unsigned long ulTestphase=0;//actual phase of the test 
	int iReturn=0;//returnvalue of the test; the number of occured Errors
	
	cout<<endl<<"Running Test for cUnivers equal operations: tcUniversEqual"<<endl;
	cout<<      "=========================================================="<<endl;

	ulTestphase++;
	iReturn += testEqual1(ulTestphase);
	
	ulTestphase++;
	iReturn += testNotEqual1(ulTestphase);
	
	ulTestphase++;
	iReturn += testEqual2(ulTestphase);
	
	ulTestphase++;
	iReturn += testEqual3(ulTestphase);
	
	ulTestphase++;
	iReturn += testEqual4(ulTestphase);
	
	
	if ( iReturn==0 )
	{
		cout<<endl<<endl<<"Test successfull: no errors occoured"<<endl;
	}else{
		cerr<<endl<<endl<<"Test failed: "<<iReturn<<" errors occoured"<<endl;
	}
	return iReturn;
}



int testEqual1(unsigned long ulTestphase)
/*Test that creates two points with the same name and compares them
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : compare a point with a secound point with the same name"<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint *point1=new cPoint();//create the cPoint
	point1->name=1;
	cout<<"Creating cPoint 2 with name 1"<<endl;
	cPoint *point2=new cPoint();//create the cPoint
	point2->name=1;
	
	cout<<"Creating sUnivers 1"<<endl;
	cUnivers univers1;
	cout<<"inserting point 1 in univers 1"<<endl;
	list<cPoint*>* univStructur1=univers1.getUniversStructur();
	univStructur1->push_back(point1);
	
	cout<<"Creating scUnivers 2"<<endl;
	cUnivers univers2;
	cout<<"inserting point 2 in univers 2"<<endl;
	list<cPoint*>* univStructur2=univers2.getUniversStructur();
	univStructur2->push_back(point2);

	if (univers1==univers2)
	{
		cout<<"cUnivers are equal "<<endl;
	}else{
		cerr<<"Error: cUnivers are not equal"<<endl;
		iReturn++;
	}

	return iReturn;
}

int testNotEqual1(unsigned long ulTestphase)
/*Test that creates two points with not the same name and compares them
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : compare a point with a secound point with not the same name"<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint *point1=new cPoint();//create the cPoint
	point1->name=1;
	cout<<"Creating cPoint 2 with name 2"<<endl;
	cPoint *point2=new cPoint();//create the cPoint
	point2->name=2;
	
	cout<<"Creating sUnivers 1"<<endl;
	cUnivers univers1;
	cout<<"inserting point 1 in univers 1"<<endl;
	list<cPoint*>* univStructur1=univers1.getUniversStructur();
	univStructur1->push_back(point1);
	
	cout<<"Creating sUnivers 2"<<endl;
	cUnivers univers2;
	cout<<"inserting point 2 in univers 2"<<endl;
	list<cPoint*>* univStructur2=univers2.getUniversStructur();
	univStructur2->push_back(point2);

	if (univers1==univers2)
	{
		cout<<"cUnivers are not equal "<<endl;
	}else{
		cerr<<"Error: cUnivers are equal"<<endl;
		iReturn++;
	}

	return iReturn;
}


int testEqual2(unsigned long ulTestphase)
/*Test that creates two nets with not the same name and compares them
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : compare two nets two points as positiv neibours each that are equal"<<endl;
	
	cout<<"Creating Net 1 with name 1"<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint *point1=new cPoint();//create the cPoint
	point1->name=1;
	
	
	cout<<"Creating cPoint 2 with name 2"<<endl;
	cPoint *point2=new cPoint();//create the cPoint
	point2->name=2;
	
	point1->pPoint.push_back(point2);
	point2->pPoint.push_back(point1);
	
	cout<<"point 1 :\""<<*point1<<"\""<<endl;
	cout<<"point 2 :\""<<*point2<<"\""<<endl;
	
	
	cout<<"Creating Net 2 with name 1"<<endl;
	cout<<"Creating cPoint 3 with name 1"<<endl;
	cPoint *point3=new cPoint();//create the cPoint
	point3->name=1;
	
	cout<<"Creating cPoint 4 with name 2"<<endl;
	cPoint *point4=new cPoint();//create the cPoint
	point4->name=2;
	
	point3->pPoint.push_back(point4);
	point4->pPoint.push_back(point3);
	
	cout<<"point 3 :\""<<*point3<<"\""<<endl;
	cout<<"point 4 :\""<<*point4<<"\""<<endl;
	
	cout<<"Creating sUnivers 1"<<endl;
	cUnivers univers1;
	cout<<"inserting point 1 and 2 in univers 1"<<endl;
	list<cPoint*>* univStructur1=univers1.getUniversStructur();
	univStructur1->push_back(point1);
	univStructur1->push_back(point2);
	
	cout<<"Creating sUnivers 2"<<endl;
	cUnivers univers2;
	cout<<"inserting point 3 and 4 in univers 2"<<endl;
	list<cPoint*>* univStructur2=univers2.getUniversStructur();
	univStructur2->push_back(point3);
	univStructur2->push_back(point4);


	if (univers1==univers2)
	{
		cout<<"cUnivers are equal "<<endl;
	}else{
		cerr<<"Error: cUnivers are not equal"<<endl;
		iReturn++;
	}
	

	return iReturn;
}

int testEqual3(unsigned long ulTestphase)
/*Test that creates two nets that are equal
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : compare two nets tree points that are equal"<<endl;
	cout<<"all points in the net are positiv neibours of point 1 of the net"<<endl;
	
	cout<<"Creating net 1 with name 1"<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint *Net1Point1=new cPoint();//create the cPoint
	Net1Point1->name=1;
	
	cout<<"Creating net 1 cPoint 2 with name 2"<<endl;
	cPoint *Net1Point2=new cPoint();//create the cPoint
	Net1Point2->name=2;
	
	cout<<"Creating net 1 cPoint 3 with name 3"<<endl;
	cPoint *Net1Point3=new cPoint();//create the cPoint
	Net1Point3->name=3;
	
	Net1Point1->pPoint.push_back(Net1Point2);
	Net1Point2->pPoint.push_back(Net1Point1);
	
	Net1Point1->pPoint.push_back(Net1Point3);
	Net1Point3->pPoint.push_back(Net1Point1);
	
	cout<<"Point 1 :\""<<*Net1Point1<<"\""<<endl;
	cout<<"Point 2 :\""<<*Net1Point2<<"\""<<endl;
	cout<<"Point 3 :\""<<*Net1Point3<<"\""<<endl;
	
	
	cout<<"Creating net 2 with name 1"<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint *Net2Point1=new cPoint();//create the cPoint
	Net2Point1->name=1;
	
	cout<<"Creating net 2 cPoint 2 with name 2"<<endl;
	cPoint *Net2Point2=new cPoint();//create the cPoint
	Net2Point2->name=2;
	
	cout<<"Creating net 2 cPoint 3 with name 3"<<endl;
	cPoint *Net2Point3=new cPoint();//create the cPoint
	Net2Point3->name=3;
	
	Net2Point1->pPoint.push_back(Net2Point3);
	Net2Point3->pPoint.push_back(Net2Point1);

	Net2Point1->pPoint.push_back(Net2Point2);
	Net2Point2->pPoint.push_back(Net2Point1);
	
	cout<<"Point 1 :\""<<*Net2Point1<<"\""<<endl;
	cout<<"Point 2 :\""<<*Net2Point2<<"\""<<endl;
	cout<<"Point 3 :\""<<*Net2Point3<<"\""<<endl;

	cout<<"Creating sUnivers 1"<<endl;
	cUnivers univers1;
	cout<<"inserting point 1 till 3 of net 1 in univers 1"<<endl;
	list<cPoint*>* univStructur1=univers1.getUniversStructur();
	univStructur1->push_back(Net1Point1);
	univStructur1->push_back(Net1Point2);
	univStructur1->push_back(Net1Point3);
	
	cout<<"Creating sUnivers 2"<<endl;
	cUnivers univers2;
	cout<<"inserting point 1 till 3 of net 2 in univers 2"<<endl;
	list<cPoint*>* univStructur2=univers2.getUniversStructur();
	univStructur2->push_back(Net2Point1);
	univStructur2->push_back(Net2Point3);
	univStructur2->push_back(Net2Point2);


	if (univers1==univers2)
	{
		cout<<"cUnivers are equal "<<endl;
	}else{
		cerr<<"Error: cUnivers are not equal"<<endl;
		iReturn++;
	}

	return iReturn;
}


int testEqual4(unsigned long ulTestphase)
/*Test that creates two nets that are equal
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : compare two nets five points that are equal"<<endl;
	
	cout<<"Creating net 1 with name 1"<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint *Net1Point1=new cPoint();//create the cPoint
	Net1Point1->name=1;
	
	cout<<"Creating net 1 cPoint 2 with name 2"<<endl;
	cPoint *Net1Point2=new cPoint();//create the cPoint
	Net1Point2->name=2;
	
	cout<<"Creating net 1 cPoint 3 with name 3"<<endl;
	cPoint *Net1Point3=new cPoint();//create the cPoint
	Net1Point3->name=3;
	
	cout<<"Creating net 1 cPoint 4 with name 4"<<endl;
	cPoint *Net1Point4=new cPoint();//create the cPoint
	Net1Point4->name=4;
	
	cout<<"Creating net 1 cPoint 5 with name 5"<<endl;
	cPoint *Net1Point5=new cPoint();//create the cPoint
	Net1Point5->name=5;
	
	Net1Point1->pPoint.push_back(Net1Point2);
	Net1Point2->pPoint.push_back(Net1Point1);
		
	Net1Point3->pPoint.push_back(Net1Point5);
	Net1Point5->pPoint.push_back(Net1Point3);
	
	Net1Point1->pPoint.push_back(Net1Point3);
	Net1Point3->pPoint.push_back(Net1Point1);
	
	Net1Point3->pPoint.push_back(Net1Point5);
	Net1Point5->pPoint.push_back(Net1Point3);
	
	Net1Point1->nPoint.push_back(Net1Point1);
	Net1Point4->nPoint.push_back(Net1Point4);
	
	Net1Point1->nPoint.push_back(Net1Point1);
	Net1Point5->nPoint.push_back(Net1Point5);
	
	cout<<"Point 1 :\""<<*Net1Point1<<"\""<<endl;
	cout<<"Point 2 :\""<<*Net1Point2<<"\""<<endl;
	cout<<"Point 3 :\""<<*Net1Point3<<"\""<<endl;
	cout<<"Point 4 :\""<<*Net1Point4<<"\""<<endl;
	cout<<"Point 5 :\""<<*Net1Point5<<"\""<<endl;
	
	
	cout<<"Creating net 2 with name 1"<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint *Net2Point1=new cPoint();//create the cPoint
	Net2Point1->name=1;
	
	cout<<"Creating net 2 cPoint 2 with name 2"<<endl;
	cPoint *Net2Point2=new cPoint();//create the cPoint
	Net2Point2->name=2;
	
	cout<<"Creating net 2 cPoint 3 with name 3"<<endl;
	cPoint *Net2Point3=new cPoint();//create the cPoint
	Net2Point3->name=3;
	
	cout<<"Creating net 2 cPoint 4 with name 4"<<endl;
	cPoint *Net2Point4=new cPoint();//create the cPoint
	Net2Point4->name=4;
	
	cout<<"Creating net 2 cPoint 5 with name 5"<<endl;
	cPoint *Net2Point5=new cPoint();//create the cPoint
	Net2Point5->name=5;
	
	Net2Point1->pPoint.push_back(Net2Point2);
	Net2Point2->pPoint.push_back(Net2Point1);
	
	Net2Point1->pPoint.push_back(Net2Point3);
	Net2Point3->pPoint.push_back(Net2Point1);
	
	Net2Point1->nPoint.push_back(Net2Point1);
	Net2Point4->nPoint.push_back(Net2Point4);
	
	Net2Point1->nPoint.push_back(Net2Point1);
	Net2Point5->nPoint.push_back(Net2Point5);
	
	Net2Point3->pPoint.push_back(Net2Point5);
	Net2Point5->pPoint.push_back(Net2Point3);
	
	Net2Point3->pPoint.push_back(Net2Point5);
	Net2Point5->pPoint.push_back(Net2Point3);
	
	cout<<"Point 1 :\""<<*Net2Point1<<"\""<<endl;
	cout<<"Point 2 :\""<<*Net2Point2<<"\""<<endl;
	cout<<"Point 3 :\""<<*Net2Point3<<"\""<<endl;
	cout<<"Point 4 :\""<<*Net2Point4<<"\""<<endl;
	cout<<"Point 5 :\""<<*Net2Point5<<"\""<<endl;
	
	cout<<"Creating sUnivers 1"<<endl;
	cUnivers univers1;
	cout<<"inserting point 1 till 5 of net 1 in univers 1"<<endl;
	list<cPoint*>* univStructur1=univers1.getUniversStructur();
	univStructur1->push_back(Net1Point1);
	univStructur1->push_back(Net1Point2);
	univStructur1->push_back(Net1Point3);
	univStructur1->push_back(Net1Point4);
	univStructur1->push_back(Net1Point5);
	
	cout<<"Creating sUnivers 2"<<endl;
	cUnivers univers2;
	cout<<"inserting point 1 till 5 of net 2 in univers 2"<<endl;
	list<cPoint*>* univStructur2=univers2.getUniversStructur();
	univStructur2->push_back(Net2Point1);
	univStructur2->push_back(Net2Point5);
	univStructur2->push_back(Net2Point3);
	univStructur2->push_back(Net2Point2);
	univStructur2->push_back(Net2Point4);

	if (univers1==univers2)
	{
		cout<<"cUnivers are equal "<<endl;
	}else{
		cerr<<"Error: cUnivers are not equal"<<endl;
		iReturn++;
	}

	return iReturn;
}
















