/*File Name: tcUniversToolsSetOp.cpp
  Author: Betti Oesterholz ; Date: 22.12.2007
  System: C++

  call: tcUniversToolsSetOp

  Description: This is the Tascase to check the set operators of the class cUniversTools.
  the Folder dataUniversToolsSetOp should contain the data neaded for this test.
  
  What's tested of class cUniversTools: 
   - unionPointLists()
   - intersectionPointLists()
   - intersectionPointListsIsEmpty()
   
   not implemented yet:
   - getPointsNotInPointLists()

  Copyright (C) 2007  Betti Oesterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  History:

*/ 

#include <time.h>
#include <sys/stat.h>
#include <cstdlib>
#include <cstdio>

#include "cUniversTools.h"


using namespace std;

int loadCUniversTools(const char * szUniversFileName, cUniversTools &uniTools);
int testUnionPointLists1(unsigned long ulTestphase);
int testIntersectPointLists1(unsigned long ulTestphase);
int testIntersectPointListsIsEmpty1(unsigned long ulTestphase);



int main(int argc,char* argv[])
{
	unsigned long ulTestphase=0;//actual phase of the test 
	int iReturn=0;//returnvalue of the test; the number of occured Errors
	
	cout<<endl<<"Running Test cUniversTools set operations: tcUniversToolsSetOp"<<endl;
	cout<<      "=============================================================="<<endl;

	ulTestphase++;
	iReturn += testUnionPointLists1(ulTestphase);
	
	ulTestphase++;
	iReturn += testIntersectPointLists1(ulTestphase);
	
	ulTestphase++;
	iReturn += testIntersectPointListsIsEmpty1(ulTestphase);
	
	
	if ( iReturn==0 )
	{
		cout<<endl<<endl<<"Test successfull: no errors occoured"<<endl;
	}else{
		cerr<<endl<<endl<<"Test failed: "<<iReturn<<" errors occoured"<<endl;
	}
	return iReturn;
}


int testUnionPointLists1(unsigned long ulTestphase)
/*Test that the union of to point list are correct
pre: number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;//returnvalue of the test; the number of occured Errors
	char szDateiname[1024];

	for (int iTestNbr=1 ; iTestNbr<=6 ; iTestNbr++ )
	{
		cout<<endl<<"TESTPASE "<<ulTestphase<<" test "<< iTestNbr <<" : union of univers parts"<<endl;
		cout<<endl<<" loading parts"<<endl;
		cUniversTools uniPart1;
		sprintf(szDateiname,"./dataUniversToolsSetOp/testUnionPointLists%dPart1.txt",iTestNbr);
		iReturn+=loadCUniversTools(szDateiname, uniPart1);
		uniPart1.printUnivers(cout);
		cUniversTools uniPart2;
		sprintf(szDateiname,"./dataUniversToolsSetOp/testUnionPointLists%dPart2.txt",iTestNbr);
		iReturn+=loadCUniversTools(szDateiname, uniPart2);
		uniPart2.printUnivers(cout);
		
		cout<<endl<<" creating Union of the parts";
		cUniversTools uniUnionCreated;
		list<cPoint*> lPointList=uniUnionCreated.unionPointLists(*(uniPart1.getUniversStructur()), *(uniPart2.getUniversStructur()));
		(*uniUnionCreated.getUniversStructur())=uniUnionCreated.copyUniversStructur(lPointList);
		
		uniUnionCreated.printUnivers(cout);
		
		cout<<endl<<" loading Union to campare to: ";
		cUniversTools uniUnionLoaded;
		sprintf(szDateiname,"./dataUniversToolsSetOp/testUnionPointLists%dUnion.txt",iTestNbr);
		iReturn+=loadCUniversTools(szDateiname, uniUnionLoaded);
		uniUnionLoaded.printUnivers(cout);
		
		cout<<endl<<" comparing unions"<<endl;
		if (uniUnionLoaded==uniUnionCreated)
		{
			cout<<"the unions are eqal; the unionPointLists() method works correct"<<endl;
		}else{
			cerr<<"Error: the unions are not eqal; the unionPointLists() method works not correct "<<endl;
			iReturn++;
		}
	}
	return iReturn;
}


int testIntersectPointLists1(unsigned long ulTestphase)
/*Test that the intersection of to point list are correct
pre: number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;//returnvalue of the test; the number of occured Errors
	char szDateiname[1024];

	for (int iTestNbr=1 ; iTestNbr<=6 ; iTestNbr++ )
	{
		cout<<endl<<"TESTPASE "<<ulTestphase<<" test "<< iTestNbr <<" : union of univers parts"<<endl;
		cout<<endl<<" loading parts"<<endl;
		cUniversTools uniPart1;
		sprintf(szDateiname,"./dataUniversToolsSetOp/testUnionPointLists%dPart1.txt",iTestNbr);
		iReturn+=loadCUniversTools(szDateiname, uniPart1);
		uniPart1.printUnivers(cout);
		cUniversTools uniPart2;
		sprintf(szDateiname,"./dataUniversToolsSetOp/testUnionPointLists%dPart2.txt",iTestNbr);
		iReturn+=loadCUniversTools(szDateiname, uniPart2);
		uniPart2.printUnivers(cout);
		
		cout<<endl<<" creating Intersection of the parts";
		cUniversTools uniIntersectCreated;
		list<cPoint*> lPointList=uniIntersectCreated.intersectionPointLists(*(uniPart1.getUniversStructur()), *(uniPart2.getUniversStructur()));
		(*uniIntersectCreated.getUniversStructur())=uniIntersectCreated.copyUniversStructur(lPointList);
		
		uniIntersectCreated.printUnivers(cout);
		
		cout<<endl<<" loading Intersection to campare to: ";
		cUniversTools uniIntersectLoaded;
		sprintf(szDateiname,"./dataUniversToolsSetOp/testUnionPointLists%dIntersection.txt",iTestNbr);
		iReturn+=loadCUniversTools(szDateiname, uniIntersectLoaded);
		uniIntersectLoaded.printUnivers(cout);
		
		cout<<endl<<" comparing intersections"<<endl;
		if (uniIntersectLoaded==uniIntersectCreated)
		{
			cout<<"the intersections are eqal; the intersectionPointLists() method works correct"<<endl;
		}else{
			cerr<<"Error: the intersections are not eqal; the intersectionPointLists() method works not correct "<<endl;
			iReturn++;
		}
	}
	return iReturn;
}


int testIntersectPointListsIsEmpty1(unsigned long ulTestphase)
/*Test that the intersection of to point list are correct
pre: number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;//returnvalue of the test; the number of occured Errors
	char szDateiname[1024];

	for (int iTestNbr=1 ; iTestNbr<=6 ; iTestNbr++ )
	{
		cout<<endl<<"TESTPASE "<<ulTestphase<<" test "<< iTestNbr <<" : union of univers parts"<<endl;
		cout<<endl<<" loading parts"<<endl;
		cUniversTools uniPart1;
		sprintf(szDateiname,"./dataUniversToolsSetOp/testUnionPointLists%dPart1.txt",iTestNbr);
		iReturn+=loadCUniversTools(szDateiname, uniPart1);
		uniPart1.printUnivers(cout);
		cUniversTools uniPart2;
		sprintf(szDateiname,"./dataUniversToolsSetOp/testUnionPointLists%dPart2.txt",iTestNbr);
		iReturn+=loadCUniversTools(szDateiname, uniPart2);
		uniPart2.printUnivers(cout);
		
		cout<<endl<<" check if Intersection of the parts are empty";
		
		bool bIntersectionIsEmpty=uniPart1.intersectionPointListsIsEmpty(*(uniPart1.getUniversStructur()), *(uniPart2.getUniversStructur()));
		
		cout<<endl<<" testing if intersections are empty"<<endl;
		switch (iTestNbr){
		// intersection should be empty
		case 3:
		case 4:
			if (bIntersectionIsEmpty)
			{
				cout<<"the intersections is empty; the intersectionPointListsIsEmpty() method works correct"<<endl;
			}else{
				cerr<<"Error: the intersections is not empty; the intersectionPointListsIsEmpty() method works not correct "<<endl;
				iReturn++;
			}
		break;
		default:// intersection should not be empty
			if (!bIntersectionIsEmpty)
			{
				cout<<"the intersections is not empty; the intersectionPointListsIsEmpty() method works correct"<<endl;
			}else{
				cerr<<"Error: the intersections is empty; the intersectionPointListsIsEmpty() method works not correct "<<endl;
				iReturn++;
			}		
		}
	}
	return iReturn;
}


int loadCUniversTools(const char * szUniversFileName, cUniversTools &uniTools)
/*loadCUniversTools() loads the Universtools from the given univers File
pre: the file name szUniversFileName of the file from wich the cUniversTools should be loaded and
	a referenz to the object uniTools to wich the file data should be loaded
post: 0 if the cUniversTools is loaded to the given uniTools; else is a error*/
{
	int iReturn=0;
	//load to new univers
	cout<<"Loading univers from "<<szUniversFileName<<endl;
	
	ifstream isUniversFile(szUniversFileName);
	if(isUniversFile)
	{
		uniTools.readUnivers(isUniversFile);
		isUniversFile.close();
	}else{
		cerr<< "Problem opening the univers file : "<<szUniversFileName<<endl ;
		iReturn++;
	}
	return iReturn;
}












