/*File Name: cReadValues.cpp
  Author: Betti Oesterholz ; Date: 27.02.2006
  System: C++


  Copyright (C) 2006  Betti Oesterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#non tested



	int charToInt(const char cDigit);
	/*makes the char c to a integer number c represents
	pre: the char c
	post: the integer number the char c represents (e.g. "1"=1) or -1 if it
		isn't a number*/

	char* readChar(ifstream &ifstrInput);
	/*reads a charstring from the given string str that is terminated with ':'
	or ';'
	pre: the input stream to read the char string from
	post: the readed string terminated with 0;
		or 0 if a error occurs*/

	char* readPath(ifstream &str, bool pathE=false);
	/*reads a path from the given string str that is terminated with ':'
	or ';'
	if pathE is true the path will be terminated with '/' (the method insert
	'/' at the end of the path if it needs to)
	pre: the input stream to read the path from
	post: the readed path terminated with 0;
		or 0 if a error occurs*/

	double readDouble(ifstream &str);
	/*reads a double number from the given string str
	pre: the input stream to read the double number from
	post: the readed double number*/

	long readInt(ifstream &str);
	/*reads a integer number from the given string str
	pre: the input stream to read the integer number from
	post: the readed integer number*/

	bool readBool(ifstream &str);
	/*reads a truth value from the given string str
	strings for true are: t, true, y, yes, w, wahr, j, ja, 1
	all other strings are readed as false;
	all strings can be writen in upper cases, just the first char of the words
	are checked
	pre: the input stream to read the truth value from
	post: the readed truth value*/

	time_t readPeriod(ifstream &str);
	/*reads a time period from the given string str
	pre: the input stream to read the time period from
	post: the readed time period as a time_t*/

	bool checkPath(char* path);
	/*checks if the given Path or file exists
	pre: a string for the path to be cheked
	post: true if the path exists, else false*/

	void cratePath(char* path);
	/*if the path folders are not existing, creats them
	pre: the string of the path that should be existing
	post: the path now exists*/

	bool searchForLine(fstream *str, long number, unsigned int rows);
	/*searches in a tabel for the line with the given number or the next grater number in front and
	lets the fstream point to the end of the line;
	the rows in the tabel must end with a ";";
	if no data is in the file, the pointers of the stream are set to the file begin;
	if ther is data in the file, but not front number greater or equal the given number, 
	the file pointers are set to the end of the file
	pre: the stream str to search in, the number to search for and the number
		of rows in the tabel in the stream
	post: the stream output pointer pointing to the end of the line wich begins
	with number*/





