#!/bin/bash
#
# File Name: quick.sh
# Author: Betti Oesterholz ; Date: 23.12.2007
# System: bash
#
#  Copyright (C) 2007  Betti Oesterholz
#
#Description: a quick test vor the univers simulators
#Time: less then 20 secounds
#
#History:
#

if ! [ -d result ]; then
	mkdir result
fi


export ORIGINAL_DIR=$(pwd)
export OUTPUT=${ORIGINAL_DIR}/result/quickOut.txt
export ERROR_OUTPUT=${ORIGINAL_DIR}/result/quickOut.txt
export SUM_OUTPUT=${ORIGINAL_DIR}/result/quickSum.txt
export ERRORS=0
export ERROR_SUM=0

# empty output files
>${OUTPUT} 
>${ERROR_OUTPUT}
>${SUM_OUTPUT}


cd ../testcase >>${OUTPUT} 2>>${ERROR_OUTPUT}


#evaluate testcases

tcPoint >>${OUTPUT} 2>>${ERROR_OUTPUT}
ERRORS=$?
ERROR_SUM=$(expr ${ERROR_SUM} + ${ERRORS})
echo "Errors in tcPoint : ${ERRORS}" >>${SUM_OUTPUT}

tcUniversEqual >>${OUTPUT} 2>>${ERROR_OUTPUT}
ERRORS=$?
ERROR_SUM=$(expr ${ERROR_SUM} + ${ERRORS})
echo "Errors in tcUniversEqual : ${ERRORS}" >>${SUM_OUTPUT}

tSaveStore 1000 10 >>${OUTPUT} 2>>${ERROR_OUTPUT}
ERRORS=$?
ERROR_SUM=$(expr ${ERROR_SUM} + ${ERRORS})
echo "Errors in tSaveStore 1000 1000 : ${ERRORS}" >>${SUM_OUTPUT}

tcUniversToolsSetOp >>${OUTPUT} 2>>${ERROR_OUTPUT}
ERRORS=$?
ERROR_SUM=$(expr ${ERROR_SUM} + ${ERRORS})
echo "Errors in tcUniversToolsSetOp : ${ERRORS}" >>${SUM_OUTPUT}


echo "---------------------" >>${SUM_OUTPUT}
echo "all Errors : ${ERROR_SUM}" >>${SUM_OUTPUT}

cd ${ORIGINAL_DIR}
cat ${OUTPUT} ${SUM_OUTPUT} > ${ORIGINAL_DIR}/result/quick.txt
cat ${SUM_OUTPUT}









