
#ifndef KEYBOARD
#define KEYBOARD

#include <termios.h>

class cKeyboard
{
public:

	/** constructor of the keyboard object */
	cKeyboard();
	
	/** destructor of the keyboard object */
	~cKeyboard();
	
	/**
	 * check if a new key was hit and is in the buffer to read
	 * @return 1 if a key was hit and is in the buffer to read, else 0
	 */
	int kbhit();
	
	/**
	 * returns an character from the keyboard buffer
	 * @return the readed character
	 */
	int getch();

private:

	struct termios initial_settings, new_settings;
	int peek_character;

};

#endif
