#!/bin/bash
#
# File Name: lsGreater.sh
# Author: Betti Oesterholz ; Date: 14.01.2007
# System: bash
#
#  Copyright (C) 2007  Betti Oesterholz
#
#Description: With this script a shorter version of the univers statistic is created.
#
#History:
STATISTIC_DIR=./statistic
STATISTIC_FILES="cut partsize statistic rTime"
SIZE_HORIZONT=3000k
UNIVERS_DIR=./univers

FILE=
for FILE in ${STATISTIC_FILES} ; do
	#evalue size of the file
	if [ -e ${STATISTIC_DIR}/${FILE}.txt  ]; then
		SIZE=$(ls --block-size=${SIZE_HORIZONT} -s -1 ${STATISTIC_DIR}/${FILE}.txt | head -c2)
	
		if [ ${SIZE} -gt 1 ]; then
			echo "Creating a short version of ${FILE}.txt"
			grep -e '^[[:alpha:]]' -e '^[0-9][0-9][[:space:]]*;' -e  '^[0-9][0-9]0*0[[:space:]]*;' ${STATISTIC_DIR}/${FILE}.txt > ${STATISTIC_DIR}/${FILE}K.txt
			if [ $? = 0 ]; then
				rm ${STATISTIC_DIR}/${FILE}.txt
				mv ${STATISTIC_DIR}/${FILE}K.txt ${STATISTIC_DIR}/${FILE}.txt
			fi
		fi
	fi
done
#deleting univers files
#DELETE_FILES=$(ls -1 -c ${UNIVERS_DIR}/univ[0-9][0-9]*[1-9]*.txt | head -n1000)
#rm -f ${UNIVERS_DIR}/univ[0-9][0-9]*[1-9]*.txt
 
