/*File Name: tcPoint.cpp
  Author: Betti Oesterholz ; Date: 27.10.2007
  System: C++

  call: tcPoint

  Description: This is the Tascase to check the class cPoint.
  
  What's tested of class cPoint: 
   - equal methods 
   - copy constructor
   - getTransPosible()
   - operator "<<"
   - lower operator "<" and lower() method
   


  Copyright (C) 2007  Betti Oesterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  History:

*/ 

#include <time.h>
#include <sys/stat.h>
#include <cstdlib>
#include <cstdio>

#include "cPoint.h"


using namespace std;

int testCreatePoint(unsigned long ulTestphase);
int testInsertPPointInNewPoint(unsigned long ulTestphase);
int testInsertNPointInNewPoint(unsigned long ulTestphase);
int testCreateNet1(unsigned long ulTestphase);
int testCreateNet2(unsigned long ulTestphase);
int testEqual1(unsigned long ulTestphase);
int testNotEqual1(unsigned long ulTestphase);
int testEqual2(unsigned long ulTestphase);
int testEqual3(unsigned long ulTestphase);
int testEqual4(unsigned long ulTestphase);
int testCopyConstructor1(unsigned long ulTestphase);
int testCopyConstructor2(unsigned long ulTestphase);
int testLower1(unsigned long ulTestphase);
int testLower2(unsigned long ulTestphase);
int testLower3(unsigned long ulTestphase);

int main(int argc,char* argv[])
{
	unsigned long ulTestphase=0;//actual phase of the test 
	int iReturn=0;//returnvalue of the test; the number of occured Errors
	
	cout<<endl<<"Running Test for cPoint operations: tcPoint"<<endl;
	cout<<      "======================================================"<<endl;

	ulTestphase++;
	iReturn += testCreatePoint(ulTestphase);
	
	ulTestphase++;
	iReturn += testInsertPPointInNewPoint(ulTestphase);
	
	ulTestphase++;
	iReturn += testInsertNPointInNewPoint(ulTestphase);
	
	ulTestphase++;
	iReturn += testCreateNet1(ulTestphase);
	
	ulTestphase++;
	iReturn += testCreateNet2(ulTestphase);
	
	ulTestphase++;
	iReturn += testEqual1(ulTestphase);
	
	ulTestphase++;
	iReturn += testNotEqual1(ulTestphase);
	
	ulTestphase++;
	iReturn += testEqual2(ulTestphase);
	
	ulTestphase++;
	iReturn += testEqual3(ulTestphase);
	
	ulTestphase++;
	iReturn += testEqual4(ulTestphase);
	
	ulTestphase++;
	iReturn += testCopyConstructor1(ulTestphase);
	
	ulTestphase++;
	iReturn += testCopyConstructor2(ulTestphase);
	
	ulTestphase++;
	iReturn += testLower1(ulTestphase);

	ulTestphase++;
	iReturn += testLower2(ulTestphase);

	ulTestphase++;
	iReturn += testLower3(ulTestphase);

	
	if ( iReturn==0 )
	{
		cout<<endl<<endl<<"Test successfull: no errors occoured"<<endl;
	}else{
		cerr<<endl<<endl<<"Test failed: "<<iReturn<<" errors occoured"<<endl;
	}
	return iReturn;
}


int testCreatePoint(unsigned long ulTestphase)
/*Test that creates one Point and checks its values
pre: number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;//returnvalue of the test; the number of occured Errors

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : Creating cPoint"<<endl;
	cPoint point1;//create the cPoint

	//check if the Values of the cPoint are blank (means correctly initialisized)
	if (point1.name==0)
	{
		cout<<"name Value is correct initializised with 0 "<<endl;
	}else{
		cerr<<"Error: name Value is not correct initializised with 0 ; it is : "<<point1.name<<endl;
		iReturn++;
	}
	if (point1.tmpValue==0)
	{
		cout<<"tmpValue Value is correct initializised with 0 "<<endl;
	}else{
		cerr<<"Error: tmpValue Value is not correct initializised with 0 ; it is : "<<point1.tmpValue<<endl;
		iReturn++;
	}
	if (point1.posNeibours==0)
	{
		cout<<"posNeibours Value is correct initializised with 0 "<<endl;
	}else{
		cerr<<"Error: posNeibours Value is not correct initializised with 0 ; it is : "<<point1.posNeibours<<endl;
		iReturn++;
	}
	if (point1.negNeibours==0)
	{
		cout<<"negNeibours Value is correct initializised with 0 "<<endl;
	}else{
		cerr<<"Error: negNeibours Value is not correct initializised with 0 ; it is : "<<point1.negNeibours<<endl;
		iReturn++;
	}
	if (point1.transPosible==1)
	{
		cout<<"transPosible Value is correct initializised with 1 "<<endl;
	}else{
		cerr<<"Error: transPosible Value is not correct initializised with 1 ; it is : "<<point1.transPosible<<endl;
		iReturn++;
	}
	if (point1.pPoint.empty())//positiv neibors
	{
		cout<<"positiv neibors are correct initializised, they are are empty "<<endl;
	}else{
		cerr<<"Error: positiv neibors are not correct initializised, they aren't are empty"<<endl;
		iReturn++;
	}
	if (point1.nPoint.empty())//negativ neibors
	{
		cout<<"negativ neibors are correct initializised, they are are empty "<<endl;
	}else{
		cerr<<"Error: negativ neibors are not correct initializised, they aren't are empty"<<endl;
		iReturn++;
	}
	
	if (point1.getTransPosible()==1)
	{
		cout<<"getTransPosible() correctly returns 1 "<<endl;
	}else{
		cerr<<"Error: getTransPosible() dosn't returns 1; it returns : "<<point1.getTransPosible()<<endl;
		iReturn++;
	}
	
	return iReturn;
}


int testInsertPPointInNewPoint(unsigned long ulTestphase)
/*Test that creates two Point, insert the two Points as a positiv neibours in the other 
point and  and checks ther values
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;//returnvalue of the test; the number of occured Errors

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : insert two points as positiv neibours of each other"<<endl;
	cout<<"Creating cPoint 1"<<endl;
	cPoint point1;//create the cPoint
	point1.name=1;
	cout<<"Creating cPoint 2"<<endl;
	cPoint point2;//create the cPoint
	point2.name=2;

	cout<<"insert points as positiv neibours"<<endl;
	point1.pPoint.push_back(&point2);
	point2.pPoint.push_back(&point1);
	
	cout<<"Punkt 1 :\""<<point1<<"\""<<endl;
	cout<<"Punkt 2 :\""<<point2<<"\""<<endl;
	
	cout<<"call getTransPosible"<<endl;
	point1.getTransPosible();
	point2.getTransPosible();
	
	cout<<"check values"<<endl;


	//check if the Values of the cPoint are blank (means correctly initialisized)
	if (point1.name==1)
	{
		cout<<"name Value is correct initializised with 1 "<<endl;
	}else{
		cerr<<"Error: name Value is not correct initializised with 1 ; it is : "<<point1.name<<endl;
		iReturn++;
	}
	if (point1.tmpValue==0)
	{
		cout<<"tmpValue Value is correct initializised with 0 "<<endl;
	}else{
		cerr<<"Error: tmpValue Value is not correct initializised with 0 ; it is : "<<point1.tmpValue<<endl;
		iReturn++;
	}
	if (point1.posNeibours==1)
	{
		cout<<"posNeibours Value is correct evalued with 1 "<<endl;
	}else{
		cerr<<"Error: posNeibours Value is not correct evalued with 1 ; it is : "<<point1.posNeibours<<endl;
		iReturn++;
	}
	if (point1.negNeibours==0)
	{
		cout<<"negNeibours Value is correct evalued with 0 "<<endl;
	}else{
		cerr<<"Error: negNeibours Value is not correct evalued with 0 ; it is : "<<point1.negNeibours<<endl;
		iReturn++;
	}
	if (point1.transPosible==4)
	{
		cout<<"transPosible Value is correct evalued with 4 "<<endl;
	}else{
		cerr<<"Error: transPosible Value is not correct evalued with 4 ; it is : "<<point1.transPosible<<endl;
		iReturn++;
	}
	if (point1.pPoint.size()==1)//positiv neibors
	{
		cout<<"positiv neibors have the correct amount of 1 "<<endl;
	}else{
		cerr<<"Error: positiv neibors dosn't have the correct amount of 1"<<endl;
		iReturn++;
	}
	if (point1.nPoint.empty())//negativ neibors
	{
		cout<<"negativ neibors are correct initializised, they are are empty "<<endl;
	}else{
		cerr<<"Error: negativ neibors are not correct initializised, they aren't are empty"<<endl;
		iReturn++;
	}
	
	if (point1.getTransPosible()==4)
	{
		cout<<"getTransPosible() correctly returns 4 "<<endl;
	}else{
		cerr<<"Error: getTransPosible() dosn't returns 4; it returns : "<<point1.getTransPosible()<<endl;
		iReturn++;
	}
	


	return iReturn;
}


int testInsertNPointInNewPoint(unsigned long ulTestphase)
/*Test that creates two Point, insert the two Points as a negativ neibours in the other 
point and  and checks ther values
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;//returnvalue of the test; the number of occured Errors

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : insert two points as negativ neibours of each other"<<endl;
	cout<<"Creating cPoint 1"<<endl;
	cPoint point1;//create the cPoint
	point1.name=1;
	cout<<"Creating cPoint 2"<<endl;
	cPoint point2;//create the cPoint
	point2.name=2;

	cout<<"insert points as negativ neibours"<<endl;
	point1.nPoint.push_back(&point2);
	point2.nPoint.push_back(&point1);
	
	cout<<"Punkt 1 :\""<<point1<<"\""<<endl;
	cout<<"Punkt 2 :\""<<point2<<"\""<<endl;
	
	cout<<"call getTransPosible"<<endl;
	point1.getTransPosible();
	point2.getTransPosible();

	cout<<"check values"<<endl;


	//check if the Values of the cPoint are blank (means correctly initialisized)
	if (point1.name==1)
	{
		cout<<"name Value is correct initializised with 1 "<<endl;
	}else{
		cerr<<"Error: name Value is not correct initializised with 1 ; it is : "<<point1.name<<endl;
		iReturn++;
	}
	if (point1.tmpValue==0)
	{
		cout<<"tmpValue Value is correct initializised with 0 "<<endl;
	}else{
		cerr<<"Error: tmpValue Value is not correct initializised with 0 ; it is : "<<point1.tmpValue<<endl;
		iReturn++;
	}
	if (point1.posNeibours==0)
	{
		cout<<"posNeibours Value is correct evalued with 1 "<<endl;
	}else{
		cerr<<"Error: posNeibours Value is not correct evalued with 1 ; it is : "<<point1.posNeibours<<endl;
		iReturn++;
	}
	if (point1.negNeibours==1)
	{
		cout<<"negNeibours Value is correct evalued with 0 "<<endl;
	}else{
		cerr<<"Error: negNeibours Value is not correct evalued with 0 ; it is : "<<point1.negNeibours<<endl;
		iReturn++;
	}
	if (point1.transPosible==4)
	{
		cout<<"transPosible Value is correct evalued with 4 "<<endl;
	}else{
		cerr<<"Error: transPosible Value is not correct evalued with 4 ; it is : "<<point1.transPosible<<endl;
		iReturn++;
	}
	if (point1.nPoint.size()==1)//positiv neibors
	{
		cout<<"negativ neibors have the correct amount of 1 "<<endl;
	}else{
		cerr<<"Error: negativ neibors dosn't have the correct amount of 1"<<endl;
		iReturn++;
	}
	if (point1.pPoint.empty())//negativ neibors
	{
		cout<<"positiv neibors are correct initializised, they are are empty "<<endl;
	}else{
		cerr<<"Error: negativ positiv are not correct initializised, they aren't are empty"<<endl;
		iReturn++;
	}
	
	if (point1.getTransPosible()==4)
	{
		cout<<"getTransPosible() correctly returns 4 "<<endl;
	}else{
		cerr<<"Error: getTransPosible() dosn't returns 4; it returns : "<<point1.getTransPosible()<<endl;
		iReturn++;
	}
	


	return iReturn;
}



int testCreateNet1(unsigned long ulTestphase)
/*Test that creates a smale Point net with 3 Points and checks its values
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;//returnvalue of the test; the number of occured Errors

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : insert two points as negativ and positiv neibours of a first point"<<endl;
	cout<<"Creating cPoint 1"<<endl;
	cPoint point1;//create the cPoint
	point1.name=1;
	cout<<"Creating cPoint 2"<<endl;
	cPoint point2;//create the cPoint
	point2.name=2;
	cout<<"Creating cPoint 3"<<endl;
	cPoint point3;//create the cPoint
	point3.name=3;

	cout<<"insert points 1 and 2 as negativ neibours"<<endl;
	point1.nPoint.push_back(&point2);
	point2.nPoint.push_back(&point1);
	
	cout<<"insert points 1 and 3 as positiv neibours"<<endl;
	point1.pPoint.push_back(&point3);
	point3.pPoint.push_back(&point1);
	
	
	cout<<"point 1 :\""<<point1<<"\""<<endl;
	cout<<"point 2 :\""<<point2<<"\""<<endl;
	cout<<"point 3 :\""<<point3<<"\""<<endl;
	
	cout<<"call getTransPosible"<<endl;
	point1.getTransPosible();
	point2.getTransPosible();
	point3.getTransPosible();

	cout<<"check values point 1:"<<endl;

	//check if the Values of the cPoint are blank (means correctly initialisized)
	if (point1.name==1)
	{
		cout<<"name Value is correct initializised with 1 "<<endl;
	}else{
		cerr<<"Error: name Value is not correct initializised with 1 ; it is : "<<point1.name<<endl;
		iReturn++;
	}
	if (point1.tmpValue==0)
	{
		cout<<"tmpValue Value is correct initializised with 0 "<<endl;
	}else{
		cerr<<"Error: tmpValue Value is not correct initializised with 0 ; it is : "<<point1.tmpValue<<endl;
		iReturn++;
	}
	if (point1.posNeibours==1)
	{
		cout<<"posNeibours Value is correct evalued with 1 "<<endl;
	}else{
		cerr<<"Error: posNeibours Value is not correct evalued with 1 ; it is : "<<point1.posNeibours<<endl;
		iReturn++;
	}
	if (point1.negNeibours==1)
	{
		cout<<"negNeibours Value is correct evalued with 1 "<<endl;
	}else{
		cerr<<"Error: negNeibours Value is not correct evalued with 1 ; it is : "<<point1.negNeibours<<endl;
		iReturn++;
	}
	if (point1.transPosible==9)
	{
		cout<<"transPosible Value is correct evalued with 9 "<<endl;
	}else{
		cerr<<"Error: transPosible Value is not correct evalued with 9 ; it is : "<<point1.transPosible<<endl;
		iReturn++;
	}
	if (point1.nPoint.size()==1)//positiv neibors
	{
		cout<<"negativ neibors have the correct amount of 1 "<<endl;
	}else{
		cerr<<"Error: negativ neibors dosn't have the correct amount of 1"<<endl;
		iReturn++;
	}
	if (point1.pPoint.size()==1)//positiv neibors
	{
		cout<<"positiv neibors have the correct amount of 1 "<<endl;
	}else{
		cerr<<"Error: positiv neibors dosn't have the correct amount of 1"<<endl;
		iReturn++;
	}
	if (point1.getTransPosible()==9)
	{
		cout<<"getTransPosible() correctly returns 9 "<<endl;
	}else{
		cerr<<"Error: getTransPosible() dosn't returns 9; it returns : "<<point1.getTransPosible()<<endl;
		iReturn++;
	}
	

	cout<<"check values point 2:"<<endl;

	//check if the Values of the cPoint are blank (means correctly initialisized)
	if (point2.name==2)
	{
		cout<<"name Value is correct initializised with 2 "<<endl;
	}else{
		cerr<<"Error: name Value is not correct initializised with 2 ; it is : "<<point2.name<<endl;
		iReturn++;
	}
	if (point2.tmpValue==0)
	{
		cout<<"tmpValue Value is correct initializised with 0 "<<endl;
	}else{
		cerr<<"Error: tmpValue Value is not correct initializised with 0 ; it is : "<<point2.tmpValue<<endl;
		iReturn++;
	}
	if (point2.posNeibours==0)
	{
		cout<<"posNeibours Value is correct evalued with 0 "<<endl;
	}else{
		cerr<<"Error: posNeibours Value is not correct evalued with 0 ; it is : "<<point2.posNeibours<<endl;
		iReturn++;
	}
	if (point2.negNeibours==1)
	{
		cout<<"negNeibours Value is correct evalued with 1 "<<endl;
	}else{
		cerr<<"Error: negNeibours Value is not correct evalued with 1 ; it is : "<<point2.negNeibours<<endl;
		iReturn++;
	}
	if (point2.transPosible==4)
	{
		cout<<"transPosible Value is correct evalued with 4 "<<endl;
	}else{
		cerr<<"Error: transPosible Value is not correct evalued with 4 ; it is : "<<point2.transPosible<<endl;
		iReturn++;
	}
	if (point2.nPoint.size()==1)//positiv neibors
	{
		cout<<"negativ neibors have the correct amount of 1 "<<endl;
	}else{
		cerr<<"Error: negativ neibors dosn't have the correct amount of 1"<<endl;
		iReturn++;
	}
	if (point2.pPoint.empty())//negativ neibors
	{
		cout<<"positiv neibors are correct initializised, they are are empty "<<endl;
	}else{
		cerr<<"Error: positiv neibours are not correct initializised, they aren't are empty"<<endl;
		iReturn++;
	}
	if (point2.getTransPosible()==4)
	{
		cout<<"getTransPosible() correctly returns 4 "<<endl;
	}else{
		cerr<<"Error: getTransPosible() dosn't returns 4; it returns : "<<point2.getTransPosible()<<endl;
		iReturn++;
	}
	
	cout<<"check values point 3:"<<endl;

	//check if the Values of the cPoint are blank (means correctly initialisized)
	if (point3.name==3)
	{
		cout<<"name Value is correct initializised with 3 "<<endl;
	}else{
		cerr<<"Error: name Value is not correct initializised with 3 ; it is : "<<point3.name<<endl;
		iReturn++;
	}
	if (point3.tmpValue==0)
	{
		cout<<"tmpValue Value is correct initializised with 0 "<<endl;
	}else{
		cerr<<"Error: tmpValue Value is not correct initializised with 0 ; it is : "<<point3.tmpValue<<endl;
		iReturn++;
	}
	if (point3.posNeibours==1)
	{
		cout<<"posNeibours Value is correct evalued with 1 "<<endl;
	}else{
		cerr<<"Error: posNeibours Value is not correct evalued with 1 ; it is : "<<point3.posNeibours<<endl;
		iReturn++;
	}
	if (point3.negNeibours==0)
	{
		cout<<"negNeibours Value is correct evalued with 0 "<<endl;
	}else{
		cerr<<"Error: negNeibours Value is not correct evalued with 0 ; it is : "<<point3.negNeibours<<endl;
		iReturn++;
	}
	if (point3.transPosible==4)
	{
		cout<<"transPosible Value is correct evalued with 4 "<<endl;
	}else{
		cerr<<"Error: transPosible Value is not correct evalued with 4 ; it is : "<<point3.transPosible<<endl;
		iReturn++;
	}
	if (point3.pPoint.size()==1)//positiv neibors
	{
		cout<<"positiv neibors have the correct amount of 1 "<<endl;
	}else{
		cerr<<"Error: positiv neibors dosn't have the correct amount of 1"<<endl;
		iReturn++;
	}
	if (point3.nPoint.empty())//negativ neibors
	{
		cout<<"negativ neibors are correct initializised, they are are empty "<<endl;
	}else{
		cerr<<"Error: negativ neibours are not correct initializised, they aren't are empty"<<endl;
		iReturn++;
	}
	if (point3.getTransPosible()==4)
	{
		cout<<"getTransPosible() correctly returns 4 "<<endl;
	}else{
		cerr<<"Error: getTransPosible() dosn't returns 4; it returns : "<<point3.getTransPosible()<<endl;
		iReturn++;
	}

	return iReturn;
}



int testCreateNet2(unsigned long ulTestphase)
/*Test that creates a smale Point net with 3 Points and checks its values
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;//returnvalue of the test; the number of occured Errors

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : insert two points as positiv neibours of a first point"<<endl;
	cout<<"Creating cPoint 1"<<endl;
	cPoint point1;//create the cPoint
	point1.name=1;
	cout<<"Creating cPoint 2"<<endl;
	cPoint point2;//create the cPoint
	point2.name=2;
	cout<<"Creating cPoint 3"<<endl;
	cPoint point3;//create the cPoint
	point3.name=3;

	cout<<"insert points 1 and 2 as positiv neibours"<<endl;
	point1.pPoint.push_back(&point2);
	point2.pPoint.push_back(&point1);
	
	cout<<"insert points 1 and 3 as positiv neibours"<<endl;
	point1.pPoint.push_back(&point3);
	point3.pPoint.push_back(&point1);
	
	
	cout<<"point 1 :\""<<point1<<"\""<<endl;
	cout<<"point 2 :\""<<point2<<"\""<<endl;
	cout<<"point 3 :\""<<point3<<"\""<<endl;
	
	cout<<"call getTransPosible"<<endl;
	point1.getTransPosible();
	point2.getTransPosible();
	point3.getTransPosible();

	cout<<"check values point 1:"<<endl;

	//check if the Values of the cPoint are blank (means correctly initialisized)
	if (point1.name==1)
	{
		cout<<"name Value is correct initializised with 1 "<<endl;
	}else{
		cerr<<"Error: name Value is not correct initializised with 1 ; it is : "<<point1.name<<endl;
		iReturn++;
	}
	if (point1.tmpValue==0)
	{
		cout<<"tmpValue Value is correct initializised with 0 "<<endl;
	}else{
		cerr<<"Error: tmpValue Value is not correct initializised with 0 ; it is : "<<point1.tmpValue<<endl;
		iReturn++;
	}
	if (point1.posNeibours==2)
	{
		cout<<"posNeibours Value is correct evalued with 2 "<<endl;
	}else{
		cerr<<"Error: posNeibours Value is not correct evalued with 2 ; it is : "<<point1.posNeibours<<endl;
		iReturn++;
	}
	if (point1.negNeibours==0)
	{
		cout<<"negNeibours Value is correct evalued with 0 "<<endl;
	}else{
		cerr<<"Error: negNeibours Value is not correct evalued with 0 ; it is : "<<point1.negNeibours<<endl;
		iReturn++;
	}
	if (point1.transPosible==9)
	{
		cout<<"transPosible Value is correct evalued with 9 "<<endl;
	}else{
		cerr<<"Error: transPosible Value is not correct evalued with 9 ; it is : "<<point1.transPosible<<endl;
		iReturn++;
	}
	if (point1.pPoint.size()==2)//positiv neibors
	{
		cout<<"positiv neibors have the correct amount of 2 "<<endl;
	}else{
		cerr<<"Error: positiv neibors dosn't have the correct amount of 2"<<endl;
		iReturn++;
	}
	if (point2.nPoint.empty())//negativ neibors
	{
		cout<<"negativ neibors are correct initializised, they are are empty "<<endl;
	}else{
		cerr<<"Error: negativ neibours are not correct initializised, they aren't are empty"<<endl;
		iReturn++;
	}
	if (point1.getTransPosible()==9)
	{
		cout<<"getTransPosible() correctly returns 9 "<<endl;
	}else{
		cerr<<"Error: getTransPosible() dosn't returns 9; it returns : "<<point1.getTransPosible()<<endl;
		iReturn++;
	}
	
	cout<<"check values point 2:"<<endl;

	//check if the Values of the cPoint are blank (means correctly initialisized)
	if (point2.name==2)
	{
		cout<<"name Value is correct initializised with 2 "<<endl;
	}else{
		cerr<<"Error: name Value is not correct initializised with 2 ; it is : "<<point2.name<<endl;
		iReturn++;
	}
	if (point2.tmpValue==0)
	{
		cout<<"tmpValue Value is correct initializised with 0 "<<endl;
	}else{
		cerr<<"Error: tmpValue Value is not correct initializised with 0 ; it is : "<<point2.tmpValue<<endl;
		iReturn++;
	}
	if (point2.posNeibours==1)
	{
		cout<<"posNeibours Value is correct evalued with 1 "<<endl;
	}else{
		cerr<<"Error: posNeibours Value is not correct evalued with 1 ; it is : "<<point2.posNeibours<<endl;
		iReturn++;
	}
	if (point2.negNeibours==0)
	{
		cout<<"negNeibours Value is correct evalued with 0 "<<endl;
	}else{
		cerr<<"Error: negNeibours Value is not correct evalued with 0 ; it is : "<<point2.negNeibours<<endl;
		iReturn++;
	}
	if (point2.transPosible==4)
	{
		cout<<"transPosible Value is correct evalued with 4 "<<endl;
	}else{
		cerr<<"Error: transPosible Value is not correct evalued with 4 ; it is : "<<point2.transPosible<<endl;
		iReturn++;
	}
	if (point2.pPoint.size()==1)//positiv neibors
	{
		cout<<"positiv neibors have the correct amount of 1 "<<endl;
	}else{
		cerr<<"Error: positiv neibors dosn't have the correct amount of 1"<<endl;
		iReturn++;
	}
	if (point2.nPoint.empty())//negativ neibors
	{
		cout<<"negativ neibors are correct initializised, they are are empty "<<endl;
	}else{
		cerr<<"Error: negativ neibours are not correct initializised, they aren't are empty"<<endl;
		iReturn++;
	}
	if (point2.getTransPosible()==4)
	{
		cout<<"getTransPosible() correctly returns 4 "<<endl;
	}else{
		cerr<<"Error: getTransPosible() dosn't returns 4; it returns : "<<point2.getTransPosible()<<endl;
		iReturn++;
	}
	
	cout<<"check values point 3:"<<endl;

	//check if the Values of the cPoint are blank (means correctly initialisized)
	if (point3.name==3)
	{
		cout<<"name Value is correct initializised with 3 "<<endl;
	}else{
		cerr<<"Error: name Value is not correct initializised with 3 ; it is : "<<point3.name<<endl;
		iReturn++;
	}
	if (point3.tmpValue==0)
	{
		cout<<"tmpValue Value is correct initializised with 0 "<<endl;
	}else{
		cerr<<"Error: tmpValue Value is not correct initializised with 0 ; it is : "<<point3.tmpValue<<endl;
		iReturn++;
	}
	if (point3.posNeibours==1)
	{
		cout<<"posNeibours Value is correct evalued with 1 "<<endl;
	}else{
		cerr<<"Error: posNeibours Value is not correct evalued with 1 ; it is : "<<point3.posNeibours<<endl;
		iReturn++;
	}
	if (point3.negNeibours==0)
	{
		cout<<"negNeibours Value is correct evalued with 0 "<<endl;
	}else{
		cerr<<"Error: negNeibours Value is not correct evalued with 0 ; it is : "<<point3.negNeibours<<endl;
		iReturn++;
	}
	if (point3.transPosible==4)
	{
		cout<<"transPosible Value is correct evalued with 4 "<<endl;
	}else{
		cerr<<"Error: transPosible Value is not correct evalued with 4 ; it is : "<<point3.transPosible<<endl;
		iReturn++;
	}
	if (point3.pPoint.size()==1)//positiv neibors
	{
		cout<<"positiv neibors have the correct amount of 1 "<<endl;
	}else{
		cerr<<"Error: positiv neibors dosn't have the correct amount of 1"<<endl;
		iReturn++;
	}
	if (point3.nPoint.empty())//negativ neibors
	{
		cout<<"negativ neibors are correct initializised, they are are empty "<<endl;
	}else{
		cerr<<"Error: negativ neibours are not correct initializised, they aren't are empty"<<endl;
		iReturn++;
	}
	if (point3.getTransPosible()==4)
	{
		cout<<"getTransPosible() correctly returns 4 "<<endl;
	}else{
		cerr<<"Error: getTransPosible() dosn't returns 4; it returns : "<<point3.getTransPosible()<<endl;
		iReturn++;
	}
	

	return iReturn;
}


int testEqual1(unsigned long ulTestphase)
/*Test that creates two points with the same name and compares them
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : compare a point with a secound point with the same name"<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint point1;//create the cPoint
	point1.name=1;
	cout<<"Creating cPoint 2 with name 1"<<endl;
	cPoint point2;//create the cPoint
	point2.name=1;

	if (point1==point2)
	{
		cout<<"cPoints are equal "<<endl;
	}else{
		cerr<<"Error: cPoints are not equal"<<endl;
		iReturn++;
	}

	return iReturn;
}

int testNotEqual1(unsigned long ulTestphase)
/*Test that creates two points with not the same name and compares them
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : compare a point with a secound point with not the same name"<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint point1;//create the cPoint
	point1.name=1;
	cout<<"Creating cPoint 2 with name 2"<<endl;
	cPoint point2;//create the cPoint
	point2.name=2;

	if (point1==point2)
	{
		cout<<"cPoints are not equal "<<endl;
	}else{
		cerr<<"Error: cPoints are equal"<<endl;
		iReturn++;
	}

	return iReturn;
}


int testEqual2(unsigned long ulTestphase)
/*Test that creates two nets with not the same name and compares them
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : compare two nets two points as positiv neibours each that are equal"<<endl;
	
	cout<<"Creating Net 1 with name 1"<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint point1;//create the cPoint
	point1.name=1;
	
	
	cout<<"Creating cPoint 2 with name 2"<<endl;
	cPoint point2;//create the cPoint
	point2.name=2;
	
	point1.pPoint.push_back(&point2);
	point2.pPoint.push_back(&point1);
	
	cout<<"point 1 :\""<<point1<<"\""<<endl;
	cout<<"point 2 :\""<<point2<<"\""<<endl;
	
	
	cout<<"Creating Net 2 with name 1"<<endl;
	cout<<"Creating cPoint 3 with name 1"<<endl;
	cPoint point3;//create the cPoint
	point3.name=1;
	
	cout<<"Creating cPoint 4 with name 2"<<endl;
	cPoint point4;//create the cPoint
	point4.name=2;
	
	point3.pPoint.push_back(&point4);
	point4.pPoint.push_back(&point3);
	
	cout<<"point 3 :\""<<point3<<"\""<<endl;
	cout<<"point 4 :\""<<point4<<"\""<<endl;
	

	if (point1==point3)
	{
		cout<<"Nets for Point 1 and 3 are equal "<<endl;
	}else{
		cerr<<"Error: Nets for Point 1 and 3 are not equal"<<endl;
		iReturn++;
	}
	
	if (point2==point4)
	{
		cout<<"Nets for Point 2 and 4 are equal "<<endl;
	}else{
		cerr<<"Error: Nets for Point 2 and 4 are not equal"<<endl;
		iReturn++;
	}

	return iReturn;
}

int testEqual3(unsigned long ulTestphase)
/*Test that creates two nets that are equal
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : compare two nets tree points that are equal"<<endl;
	cout<<"all points in the net are positiv neibours of point 1 of the net"<<endl;
	
	cout<<"Creating net 1 with name 1"<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint Net1Point1;//create the cPoint
	Net1Point1.name=1;
	
	cout<<"Creating net 1 cPoint 2 with name 2"<<endl;
	cPoint Net1Point2;//create the cPoint
	Net1Point2.name=2;
	
	cout<<"Creating net 1 cPoint 3 with name 3"<<endl;
	cPoint Net1Point3;//create the cPoint
	Net1Point3.name=3;
	
	Net1Point1.pPoint.push_back(&Net1Point2);
	Net1Point2.pPoint.push_back(&Net1Point1);
	
	Net1Point1.pPoint.push_back(&Net1Point3);
	Net1Point3.pPoint.push_back(&Net1Point1);
	
	cout<<"Point 1 :\""<<Net1Point1<<"\""<<endl;
	cout<<"Point 2 :\""<<Net1Point2<<"\""<<endl;
	cout<<"Point 3 :\""<<Net1Point3<<"\""<<endl;
	
	
	cout<<"Creating net 2 with name 1"<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint Net2Point1;//create the cPoint
	Net2Point1.name=1;
	
	cout<<"Creating net 2 cPoint 2 with name 2"<<endl;
	cPoint Net2Point2;//create the cPoint
	Net2Point2.name=2;
	
	cout<<"Creating net 2 cPoint 3 with name 3"<<endl;
	cPoint Net2Point3;//create the cPoint
	Net2Point3.name=3;
	
	Net2Point1.pPoint.push_back(&Net2Point3);
	Net2Point3.pPoint.push_back(&Net2Point1);

	Net2Point1.pPoint.push_back(&Net2Point2);
	Net2Point2.pPoint.push_back(&Net2Point1);
	
	cout<<"Point 1 :\""<<Net2Point1<<"\""<<endl;
	cout<<"Point 2 :\""<<Net2Point2<<"\""<<endl;
	cout<<"Point 3 :\""<<Net2Point3<<"\""<<endl;

	if (Net1Point1==Net2Point1)
	{
		cout<<"For cPoint 1 net 1 and 2 are equal "<<endl;
	}else{
		cerr<<"Error: For cPoint 1 net 1 and 2 are not equal "<<endl;
		iReturn++;
	}
	
	if (Net1Point2==Net2Point2)
	{
		cout<<"For cPoint 2 net 1 and 2 are equal "<<endl;
	}else{
		cerr<<"Error: For cPoint 2 net 1 and 2 are not equal "<<endl;
		iReturn++;
	}
	if (Net1Point3==Net2Point3)
	{
		cout<<"For cPoint 3 net 1 and 2 are equal "<<endl;
	}else{
		cerr<<"Error: For cPoint 3 net 1 and 2 are not equal "<<endl;
		iReturn++;
	}

	return iReturn;
}


int testEqual4(unsigned long ulTestphase)
/*Test that creates two nets that are equal
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : compare two nets five points that are equal"<<endl;
	
	cout<<"Creating net 1 with name 1"<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint Net1Point1;//create the cPoint
	Net1Point1.name=1;
	
	cout<<"Creating net 1 cPoint 2 with name 2"<<endl;
	cPoint Net1Point2;//create the cPoint
	Net1Point2.name=2;
	
	cout<<"Creating net 1 cPoint 3 with name 3"<<endl;
	cPoint Net1Point3;//create the cPoint
	Net1Point3.name=3;
	
	cout<<"Creating net 1 cPoint 4 with name 4"<<endl;
	cPoint Net1Point4;//create the cPoint
	Net1Point4.name=4;
	
	cout<<"Creating net 1 cPoint 5 with name 5"<<endl;
	cPoint Net1Point5;//create the cPoint
	Net1Point5.name=5;
	
	Net1Point1.pPoint.push_back(&Net1Point2);
	Net1Point2.pPoint.push_back(&Net1Point1);
	
	Net1Point3.pPoint.push_back(&Net1Point5);
	Net1Point5.pPoint.push_back(&Net1Point3);
	
	Net1Point1.pPoint.push_back(&Net1Point3);
	Net1Point3.pPoint.push_back(&Net1Point1);
	
	Net1Point3.pPoint.push_back(&Net1Point5);
	Net1Point5.pPoint.push_back(&Net1Point3);
	
	Net1Point1.nPoint.push_back(&Net1Point1);
	Net1Point4.nPoint.push_back(&Net1Point4);
	
	Net1Point1.nPoint.push_back(&Net1Point1);
	Net1Point5.nPoint.push_back(&Net1Point5);
	
	cout<<"Point 1 :\""<<Net1Point1<<"\""<<endl;
	cout<<"Point 2 :\""<<Net1Point2<<"\""<<endl;
	cout<<"Point 3 :\""<<Net1Point3<<"\""<<endl;
	cout<<"Point 4 :\""<<Net1Point4<<"\""<<endl;
	cout<<"Point 5 :\""<<Net1Point5<<"\""<<endl;
	
	
	cout<<"Creating net 2 with name 1"<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint Net2Point1;//create the cPoint
	Net2Point1.name=1;
	
	cout<<"Creating net 2 cPoint 2 with name 2"<<endl;
	cPoint Net2Point2;//create the cPoint
	Net2Point2.name=2;
	
	cout<<"Creating net 2 cPoint 3 with name 3"<<endl;
	cPoint Net2Point3;//create the cPoint
	Net2Point3.name=3;
	
	cout<<"Creating net 2 cPoint 4 with name 4"<<endl;
	cPoint Net2Point4;//create the cPoint
	Net2Point4.name=4;
	
	cout<<"Creating net 2 cPoint 5 with name 5"<<endl;
	cPoint Net2Point5;//create the cPoint
	Net2Point5.name=5;
	
	Net2Point1.pPoint.push_back(&Net2Point2);
	Net2Point2.pPoint.push_back(&Net2Point1);
	
	Net2Point1.pPoint.push_back(&Net2Point3);
	Net2Point3.pPoint.push_back(&Net2Point1);
	
	Net2Point1.nPoint.push_back(&Net2Point1);
	Net2Point4.nPoint.push_back(&Net2Point4);
	
	Net2Point1.nPoint.push_back(&Net2Point1);
	Net2Point5.nPoint.push_back(&Net2Point5);
	
	Net2Point3.pPoint.push_back(&Net2Point5);
	Net2Point5.pPoint.push_back(&Net2Point3);
	
	Net2Point3.pPoint.push_back(&Net2Point5);
	Net2Point5.pPoint.push_back(&Net2Point3);
	
	cout<<"Point 1 :\""<<Net2Point1<<"\""<<endl;
	cout<<"Point 2 :\""<<Net2Point2<<"\""<<endl;
	cout<<"Point 3 :\""<<Net2Point3<<"\""<<endl;
	cout<<"Point 4 :\""<<Net2Point4<<"\""<<endl;
	cout<<"Point 5 :\""<<Net2Point5<<"\""<<endl;
	
			
	if (Net1Point1==Net2Point1)
	{
		cout<<"For cPoint 1 net 1 and 2 are equal "<<endl;
	}else{
		cerr<<"Error: For cPoint 1 net 1 and 2 are not equal "<<endl;
		iReturn++;
	}
	if (Net1Point2==Net2Point2)
	{
		cout<<"For cPoint 2 net 1 and 2 are equal "<<endl;
	}else{
		cerr<<"Error: For cPoint 2 net 1 and 2 are not equal "<<endl;
		iReturn++;
	}
	if (Net1Point3==Net2Point3)
	{
		cout<<"For cPoint 3 net 1 and 2 are equal "<<endl;
	}else{
		cerr<<"Error: For cPoint 3 net 1 and 2 are not equal "<<endl;
		iReturn++;
	}
	if (Net1Point4==Net2Point4)
	{
		cout<<"For cPoint 4 net 1 and 2 are equal "<<endl;
	}else{
		cerr<<"Error: For cPoint 4 net 1 and 2 are not equal "<<endl;
		iReturn++;
	}
	if (Net1Point5==Net2Point5)
	{
		cout<<"For cPoint 5 net 1 and 2 are equal "<<endl;
	}else{
		cerr<<"Error: For cPoint 5 net 1 and 2 are not equal "<<endl;
		iReturn++;
	}

	return iReturn;
}


int testCopyConstructor1(unsigned long ulTestphase)
/*Test that creates a point and copies it per copy constructor 
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : coping a point with copy constructor and compare them "<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint point1;//create the cPoint
	point1.name=1;
	cout<<"Copying cPoint 1 to cPoint 2 "<<endl;
	cPoint point2(point1);//create the cPoint

	if (point1==point2)
	{
		cout<<"cPoints are equal "<<endl;
	}else{
		cerr<<"Error: cPoints are not equal"<<endl;
		iReturn++;
	}

	return iReturn;
}

int testCopyConstructor2(unsigned long ulTestphase)
/*Test that creates a net with 5 ponts and copies it per copy constructor to 5 other points
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : coping a points with copy constructor and compare them "<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint Net1Point1;//create the cPoint
	Net1Point1.name=1;
	
	cout<<"Creating net 1 cPoint 2 with name 2"<<endl;
	cPoint Net1Point2;//create the cPoint
	Net1Point2.name=2;
	
	cout<<"Creating net 1 cPoint 3 with name 3"<<endl;
	cPoint Net1Point3;//create the cPoint
	Net1Point3.name=3;
	
	cout<<"Creating net 1 cPoint 4 with name 4"<<endl;
	cPoint Net1Point4;//create the cPoint
	Net1Point4.name=4;
	
	cout<<"Creating net 1 cPoint 5 with name 5"<<endl;
	cPoint Net1Point5;//create the cPoint
	Net1Point5.name=5;
	
	Net1Point1.pPoint.push_back(&Net1Point2);
	Net1Point2.pPoint.push_back(&Net1Point1);
	
	Net1Point3.pPoint.push_back(&Net1Point5);
	Net1Point5.pPoint.push_back(&Net1Point3);
	
	Net1Point1.pPoint.push_back(&Net1Point3);
	Net1Point3.pPoint.push_back(&Net1Point1);
	
	Net1Point3.pPoint.push_back(&Net1Point5);
	Net1Point5.pPoint.push_back(&Net1Point3);
	
	Net1Point1.nPoint.push_back(&Net1Point1);
	Net1Point4.nPoint.push_back(&Net1Point4);
	
	Net1Point1.nPoint.push_back(&Net1Point1);
	Net1Point5.nPoint.push_back(&Net1Point5);
	
	cout<<"Copying the 5 cPoints of net 1 to in 5 cPoint of net 2 "<<endl;
	cPoint Net2Point1(Net1Point1);//create the cPoint
	cPoint Net2Point2(Net1Point2);//create the cPoint
	cPoint Net2Point3(Net1Point3);//create the cPoint
	cPoint Net2Point4(Net1Point4);//create the cPoint
	cPoint Net2Point5(Net1Point5);//create the cPoint

	if (Net1Point1==Net2Point1)
	{
		cout<<"cPoints 1 are equal "<<endl;
	}else{
		cerr<<"Error: cPoints 1 are not equal"<<endl;
		iReturn++;
	}
	if (Net1Point2==Net2Point2)
	{
		cout<<"cPoints 2 are equal "<<endl;
	}else{
		cerr<<"Error: cPoints 2 are not equal"<<endl;
		iReturn++;
	}
	if (Net1Point3==Net2Point3)
	{
		cout<<"cPoints 3 are equal "<<endl;
	}else{
		cerr<<"Error: cPoints 3 are not equal"<<endl;
		iReturn++;
	}
	if (Net1Point4==Net2Point4)
	{
		cout<<"cPoints 4 are equal "<<endl;
	}else{
		cerr<<"Error: cPoints 4 are not equal"<<endl;
		iReturn++;
	}
	if (Net1Point5==Net2Point5)
	{
		cout<<"cPoints 5 are equal "<<endl;
	}else{
		cerr<<"Error: cPoints 5 are not equal"<<endl;
		iReturn++;
	}

	return iReturn;
}


int testLower1(unsigned long ulTestphase)
/*Test that creates two points with the same name and compares them with 
lower operator "<" and lower() method
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : compare a point with a secound point with the same name"<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint point1;//create the cPoint
	point1.name=1;
	cout<<"Creating cPoint 2 with name 1"<<endl;
	cPoint point2;//create the cPoint
	point2.name=1;

	if ( ! (point1<point2) )
	{
		cout<<"cPoint 1 is not lower '<' cPoint 2  "<<endl;
	}else{
		cerr<<"Error: cPoint 1 is lower '<' cPoint 2"<<endl;
		iReturn++;
	}
	
	if ( ! point1.lower(&point1,&point2) )
	{
		cout<<"cPoint 1 is not lower cPoint 2"<<endl;
	}else{
		cerr<<"Error: cPoint 1 is lower cPoint 2"<<endl;
		iReturn++;
	}
	
	if ( ! (point2<point1) )
	{
		cout<<"cPoint 2 is not lower '<' cPoint 1"<<endl;
	}else{
		cerr<<"Error: cPoint 2 is lower '<' cPoint 1"<<endl;
		iReturn++;
	}
	
	if ( ! point2.lower(&point2,&point1) )
	{
		cout<<"cPoint 2 is not lower cPoint 1"<<endl;
	}else{
		cerr<<"Error: cPoint 2 is lower cPoint 1"<<endl;
		iReturn++;
	}

	return iReturn;
}

int testLower2(unsigned long ulTestphase)
/*Test that creates two points with not the same name and compares them with 
lower operator "<" and lower() method
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : compare a point with a secound point with not the same name"<<endl;
	cout<<"Creating cPoint 1 with name 1"<<endl;
	cPoint point1;//create the cPoint
	point1.name=1;
	cout<<"Creating cPoint 2 with name 2"<<endl;
	cPoint point2;//create the cPoint
	point2.name=2;

	if (point1<point2)
	{
		cout<<"cPoint 1 is lower '<' cPoint 2"<<endl;
	}else{
		cerr<<"Error: cPoint 1 is not lower '<' cPoint 2"<<endl;
		iReturn++;
	}
	
	if (point1.lower(&point1,&point2))
	{
		cout<<"cPoint 1 is lower cPoint 2  "<<endl;
	}else{
		cerr<<"Error: cPoint 1 is not lower cPoint 2"<<endl;
		iReturn++;
	}
	
	if ( ! (point2<point1) )
	{
		cout<<"cPoint 2 is not lower '<' cPoint 1  "<<endl;
	}else{
		cerr<<"Error: cPoint 2 is lower '<' cPoint 1"<<endl;
		iReturn++;
	}
	
	if ( ! point1.lower(&point2,&point1) )
	{
		cout<<"cPoint 2 is not lower cPoint 1"<<endl;
	}else{
		cerr<<"Error: cPoint 2 is lower cPoint 1"<<endl;
		iReturn++;
	}

	return iReturn;
}


int testLower3(unsigned long ulTestphase)
/*Test that creates two nets with not the same name and compares them with 
lower operator "<" and lower() method
pre:  number of the Testphase
post: number of Errors that occoured in this test
*/
{
	int iReturn=0;

	cout<<endl<<"TESTPASE "<<ulTestphase<<" : compare two nets two points as positiv neibours each that are equal"<<endl;
	
	cout<<"Creating Net 1 with name 1"<<endl;
	cout<<"Creating cPoint 1 with name 7"<<endl;
	cPoint point1;//create the cPoint
	point1.name=7;
	
	cout<<"Creating cPoint 2 with name 4"<<endl;
	cPoint point2;//create the cPoint
	point2.name=4;
	
	point1.pPoint.push_back(&point2);
	point2.pPoint.push_back(&point1);
	
	cout<<"point 1 :\""<<point1<<"\""<<endl;
	cout<<"point 2 :\""<<point2<<"\""<<endl;
	
	cout<<"Creating Net 2"<<endl;
	cout<<"Creating cPoint 3 with name 4"<<endl;
	cPoint point3;//create the cPoint
	point3.name=4;
	
	cout<<"Creating cPoint 4 with name 3"<<endl;
	cPoint point4;//create the cPoint
	point4.name=3;
	
	point3.nPoint.push_back(&point4);
	point4.nPoint.push_back(&point3);
	
	cout<<"point 3 :\""<<point3<<"\""<<endl;
	cout<<"point 4 :\""<<point4<<"\""<<endl;
	
/*compare 1 and 2*/
	if (! (point1<point2) )
	{
		cout<<"cPoint 1 is not lower '<' cPoint 2"<<endl;
	}else{
		cerr<<"Error: cPoint 1 is lower '<' cPoint 2"<<endl;
		iReturn++;
	}
	
	if (! point1.lower(&point1,&point2) )
	{
		cout<<"cPoint 1 is not lower cPoint 2  "<<endl;
	}else{
		cerr<<"Error: cPoint 1 is lower cPoint 2"<<endl;
		iReturn++;
	}
	
	if (point2<point1)
	{
		cout<<"cPoint 2 is lower '<' cPoint 1  "<<endl;
	}else{
		cerr<<"Error: cPoint 2 is not lower '<' cPoint 1"<<endl;
		iReturn++;
	}
	
	if (point1.lower(&point2,&point1) )
	{
		cout<<"cPoint 2 is lower cPoint 1"<<endl;
	}else{
		cerr<<"Error: cPoint 2 is not lower cPoint 1"<<endl;
		iReturn++;
	}

/*compare 1 and 3*/
	if ( ! (point1<point3) )
	{
		cout<<"cPoint 1 is not lower '<' cPoint 3"<<endl;
	}else{
		cerr<<"Error: cPoint 1 is lower '<' cPoint 3"<<endl;
		iReturn++;
	}
	
	if ( ! point1.lower(&point1,&point3) )
	{
		cout<<"cPoint 1 is not lower cPoint 3"<<endl;
	}else{
		cerr<<"Error: cPoint 1 is lower cPoint 3"<<endl;
		iReturn++;
	}
	
	if (point3<point1)
	{
		cout<<"cPoint 3 is lower '<' cPoint 1"<<endl;
	}else{
		cerr<<"Error: cPoint 3 is not lower '<' cPoint 1"<<endl;
		iReturn++;
	}
	
	if (point1.lower(&point3,&point1))
	{
		cout<<"cPoint 3 is lower cPoint 1"<<endl;
	}else{
		cerr<<"Error: cPoint 3 is not lower cPoint 1"<<endl;
		iReturn++;
	}

/*compare 1 and 4*/
	if ( ! (point1<point4) )
	{
		cout<<"cPoint 1 is not lower '<' cPoint 4"<<endl;
	}else{
		cerr<<"Error: cPoint 1 is lower '<' cPoint 4"<<endl;
		iReturn++;
	}
	
	if ( ! point1.lower(&point1,&point4) )
	{
		cout<<"cPoint 1 is not lower cPoint 4"<<endl;
	}else{
		cerr<<"Error: cPoint 1 is lower cPoint 4"<<endl;
		iReturn++;
	}
	
	if (point4<point1)
	{
		cout<<"cPoint 4 is lower '<' cPoint 1"<<endl;
	}else{
		cerr<<"Error: cPoint 4 is not lower '<' cPoint 1"<<endl;
		iReturn++;
	}
	
	if (point1.lower(&point4,&point1))
	{
		cout<<"cPoint 4 is lower cPoint 1"<<endl;
	}else{
		cerr<<"Error: cPoint 4 is not lower cPoint 1"<<endl;
		iReturn++;
	}

/*compare 2 and 3*/
	if ( ! (point2<point3) )
	{
		cout<<"cPoint 2 is not lower '<' cPoint 3"<<endl;
	}else{
		cerr<<"Error: cPoint 2 is lower '<' cPoint 3"<<endl;
		iReturn++;
	}
	
	if ( ! point1.lower(&point2,&point3) )
	{
		cout<<"cPoint 2 is not lower cPoint 3"<<endl;
	}else{
		cerr<<"Error: cPoint 2 is lower cPoint 3"<<endl;
		iReturn++;
	}
	
	if ( ! (point3<point2) )
	{
		cout<<"cPoint 3 is not lower '<' cPoint 2"<<endl;
	}else{
		cerr<<"Error: cPoint 3 is lower '<' cPoint 2"<<endl;
		iReturn++;
	}
	
	if ( ! point1.lower(&point3,&point2) )
	{
		cout<<"cPoint 3 is not lower cPoint 2"<<endl;
	}else{
		cerr<<"Error: cPoint 3 is lower cPoint 2"<<endl;
		iReturn++;
	}

/*compare 2 and 4*/
	if ( ! (point2<point4) )
	{
		cout<<"cPoint 2 is not lower '<' cPoint 4"<<endl;
	}else{
		cerr<<"Error: cPoint 2 is lower '<' cPoint 4"<<endl;
		iReturn++;
	}
	
	if ( ! point1.lower(&point2,&point4) )
	{
		cout<<"cPoint 2 is not lower cPoint 4"<<endl;
	}else{
		cerr<<"Error: cPoint 2 is lower cPoint 4"<<endl;
		iReturn++;
	}
	
	if (point4<point2)
	{
		cout<<"cPoint 4 is lower '<' cPoint 2"<<endl;
	}else{
		cerr<<"Error: cPoint 4 is not lower '<' cPoint 2"<<endl;
		iReturn++;
	}
	
	if (point1.lower(&point4,&point2) )
	{
		cout<<"cPoint 4 is lower cPoint 2"<<endl;
	}else{
		cerr<<"Error: cPoint 4 is not lower cPoint 2"<<endl;
		iReturn++;
	}

/*compare 3 and 4*/
	if ( ! (point3<point4) )
	{
		cout<<"cPoint 3 is not lower '<' cPoint 4"<<endl;
	}else{
		cerr<<"Error: cPoint 3 is lower '<' cPoint 4"<<endl;
		iReturn++;
	}
	
	if ( ! point1.lower(&point3,&point4) )
	{
		cout<<"cPoint 3 is not lower cPoint 4"<<endl;
	}else{
		cerr<<"Error: cPoint 3 is lower cPoint 4"<<endl;
		iReturn++;
	}
	
	if ( point4<point3 )
	{
		cout<<"cPoint 4 is lower '<' cPoint 3"<<endl;
	}else{
		cerr<<"Error: cPoint 4 is not lower '<' cPoint 3"<<endl;
		iReturn++;
	}
	
	if ( point1.lower(&point4,&point3) )
	{
		cout<<"cPoint 4 is lower cPoint 3"<<endl;
	}else{
		cerr<<"Error: cPoint 4 is not lower cPoint 3"<<endl;
		iReturn++;
	}

	return iReturn;
}












