set terminal postscript
set contour base
set surface
set isosamples 20
set data style lines
#set dgrid3d 20,20,3
#set nokey
set format xy "%g"
set xrange [0:20]
set yrange [0:20]

#set xlabel "number of positiv distances"
#set ylabel "number of negativ distances"
#set zlabel "probability"

set xlabel "positive Nachbarpunkte"
set ylabel "negative Nachbarpunkte"
set zlabel "Wahrscheinlichkeit"

set output "./pT1.ps"
#set title "probability of transition 1"
f(np,nn)= (np*np)/((np + nn +1)*(np + nn +1))
splot f(x,y) title "Wahrscheinlichkeit"

set output "./pT4.ps"
#set title "probability of transition 2"
f(np,nn)=(nn*nn)/((np + nn +1)*(np + nn +1))
splot f(x,y) title "Wahrscheinlichkeit"

set output "./pT2.ps"
#set title "probability of transition 3"
f(np,nn)= np*nn/((np + nn +1)*(np + nn +1))
splot f(x,y) title "Wahrscheinlichkeit"

set output "./pT3.ps"
#set title "probability of transition 4"
f(np,nn)= np*nn/((np + nn +1)*(np + nn +1))
splot f(x,y) title "Wahrscheinlichkeit"

set output "./pT5.ps"
#set title "probability of transition 5"
f(np,nn)= np/((np + nn +1)*(np + nn +1))
splot f(x,y) title "Wahrscheinlichkeit"

set output "./pT6.ps"
#set title "probability of transition 6"
f(np,nn)= np/((np + nn +1)*(np + nn +1))
splot f(x,y) title "Wahrscheinlichkeit"

set output "./pT7.ps"
#set title "probability of transition 7"
f(np,nn)= nn/((np + nn +1)*(np + nn +1))
splot f(x,y) title "Wahrscheinlichkeit"

set output "./pT8.ps"
#set title "probability of transition 8"
f(np,nn)= nn/((np + nn +1)*(np + nn +1))
splot f(x,y) title "Wahrscheinlichkeit"

set output "./pT9.ps"
#set title "probability of transition 9"
f(np,nn)=(1/(np+nn+1))*(1/(np+nn+1))
splot f(x,y) title "Wahrscheinlichkeit"

set output "./pTnew.ps"
#set title "probability that a new distance is created"
f(np,nn)=((np*nn+np+nn+1)/(np+nn+1))*(1/(np+nn+1))
splot f(x,y) title "Wahrscheinlichkeit"

set output "./pTdel.ps"
#set title "probability that a distance is deleted"
f(np,nn)= np*nn/((np + nn +1)*(np + nn +1))
splot f(x,y) title "Wahrscheinlichkeit"

set output "./pTp_neu.ps"
#set title "probability that points are created"
f(np,nn)= (2*np+2*nn+ 1)/((np + nn +1)*(np + nn +1))
splot f(x,y) title "Wahrscheinlichkeit"

set output "./pTp_del.ps"
#set title "probability that a point is maybe is disconected"
f(np,nn)= (np*nn+np+nn)/((np + nn +1)*(np + nn +1))
splot f(x,y) title "Wahrscheinlichkeit"

set output "./pTae.ps"
#set title "probability that a distance is moved in the existing univers"
f(np,nn)= (np*np+nn*nn)/((np + nn +1)*(np + nn +1))
splot f(x,y) title "Wahrscheinlichkeit"

set output "./pTan.ps"
#set title "probability that a distance is moved to a new point"
f(np,nn)= (np+nn)/((np + nn +1)*(np + nn +1))
splot f(x,y) title "Wahrscheinlichkeit"

set output "./pTa.ps"
#set title "probability that a distance is moved"
f(np,nn)= (np*np+nn*nn+np+nn)/((np + nn +1)*(np + nn +1))
splot f(x,y) title "Wahrscheinlichkeit"

set zlabel "Distanzen"
set output "./avDistGrow.ps"
#set title "average distance grow"
f(np,nn)=  1/(np + nn +1)
splot f(x,y) title "Durchschnitt"

set zlabel "Punkte"
set output "./avNewPoints.ps"
#set title "average new points"
f(np,nn)=  2/(np + nn +1)
splot f(x,y) title "Durchschnitt"













